#include "mbed.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogIn Button(p15);       // elevator button press Voltage = 3.3*0.2*n ; n = Floor Number
Serial pc(USBTX, USBRX);

int desired_floor = 0;
int keyPressed;

void bpc_func(void const *args);
void led_update();
Thread * bpc_thread;

int main()
{

    bpc_thread = new Thread(bpc_func);


    while(1) {
        led_update();
        wait(.25);
    }
}

void led_update() {
    if (desired_floor == 1) {
        led1 = 1;
        led2 = 0;
        led3 = 0;
        led4 = 0;
    }
    if (desired_floor == 2) {
        led2 = 1;
        led1 = 0;
        led3 = 0;
        led4 = 0;
    }
    if (desired_floor == 3) {
        led3 = 1;
        led2 = 0;
        led1 = 0;
        led4 = 0;
    }
    if (desired_floor == 4) {
        led4 = 1;
        led2 = 0;
        led3 = 0;
        led1 = 0;
    }
    if (desired_floor == 5) {
        led4 = 1;
        led1 = 1;
        led2 = 0;
        led3 = 0;
    }
}

void bpc_func(void const *args)
{
    while (1) {
        float ADC_val = Button.read(); 
        
        int val = ADC_val*10;

        if(val == 2) {
            desired_floor = 1;
            keyPressed = 1;
            
        } else if(val == 4) {
            desired_floor = 2;
            keyPressed = 1;
            pc.printf("2nd floor : %d \n" , val);
        } else if(val == 6) {
            desired_floor = 3;
            keyPressed = 1;
        } else if(val == 8) {
            desired_floor = 4;
            keyPressed = 1;
        } else if(val == 10) {
            desired_floor = 5;
            keyPressed = 1;
        }
        
        wait(0.25);
        
    }
}