#include "mbed.h"
#include "Pixy.h"

// init board
Pixy pixy(Pixy::SPI, p11, p12, p13);
Serial pc(USBTX, USBRX);
DigitalOut pin1(p24);
DigitalOut pin2(p25);

#if   defined(TARGET_LPC1768)
Serial blue(p9, p10);          // TX, RX
//Serial blue(p13, p14);         // TX, RX
#elif defined(TARGET_LPC4330_M4)
Serial blue(P6_4, P6_5);         // UART0_TX, UART0_RX
//Serial blue(P2_3, P2_4);         // UART3_TX, UART3_RX
#endif

// global vars
int num_readings = 0;
int total_y = 0;
float result_level = 0; // mL
float result_hourly = 0; // mL/hr
float prev_level = 0;

// funcs and threads
void get_volume(int i);
void get_hourly(void const *args);
RtosTimer get_hourly_thread(get_hourly, osTimerPeriodic);

int main() {
    
    // init bluetooth
    blue.baud(9600);
    
    // init pc
    pc.baud(9600);
    pc.printf("Bluetooth Start\r\n");
    pc.printf("ready\n\r");
    
    // init pixy
    pixy.setSerialOutput(&pc);
    
    // start entry pump
    pin1 = 1;
    pin2 = 0;
    
    // start hourly thread
    get_hourly_thread.start(10000);

    while (1) {
       
        // get pixy data
        uint16_t blocks;
        blocks = pixy.getBlocks();
        
        // store data
        if (blocks) {
            for (int j = 0; j < blocks; j++) {
                get_volume(pixy.blocks[j].y);
            }
        }
    }
}

void update_display(void const *args) {
    result_hourly = (result_level-prev_level)*6
    prev_level = result_level;
}

void get_volume(int y) {
    
    // update data
    total_y += y;
    num_readings++;
    
    // output results
    if (num_readings >= 10) {
        float average_y = (float)total_y/num_readings;
        float result_level = -0.2642*average_y + 38.453;
        
        // to pc
        pc.printf("y = %d, num_readings = %d, average = %.2f, mL = %.2f, rate = %.2f\r\n", y, num_readings, average_y, result_level, result_hourly);
        pc.printf("%.2f %.2f\r\n", result_level, result_hourly);
        
        // to bluetooth
        //blue.printf("y = %d, num_readings = %d, average = %.2f, mL = %.2f\r\n", y, num_readings, average_y, result);
        blue.printf("%.2f\r\n", result);

        // reset vars
        num_readings = 0;
        total_y = 0;
    }
}