#include "mbed.h"
#include "Pixy.h"

// init board
Pixy pixy(Pixy::SPI, p11, p12, p13);
Serial pc(USBTX, USBRX);

#if   defined(TARGET_LPC1768)
Serial blue(p9, p10);          // TX, RX
//Serial blue(p13, p14);         // TX, RX
#elif defined(TARGET_LPC4330_M4)
Serial blue(P6_4, P6_5);         // UART0_TX, UART0_RX
//Serial blue(P2_3, P2_4);         // UART3_TX, UART3_RX
#endif

// global vars
int num_readings = 0;
int total_y = 0;

// funcs
void get_volume(int i);

int main() {
    
    // init bluetooth
    blue.baud(9600);
    
    // init pc
    pc.baud(9600);
    pc.printf("Bluetooth Start\r\n");
    pc.printf("ready\n\r");
    
    // init pixy
    pixy.setSerialOutput(&pc);
    
    while (1) {
       
        // get pixy data
        uint16_t blocks;
        blocks = pixy.getBlocks();
        
        // store data
        if (blocks) {
            for (int j = 0; j < blocks; j++) {
                get_volume(pixy.blocks[j].y);
            }
        }
    }
}

void get_volume(int y) {
    
    // update data
    total_y += y;
    num_readings++;
    
    // output results
    if (num_readings >= 20) {
        float average_y = (float)total_y/num_readings;
        float result = -2.0028*average_y + 327.23;
        
        // to pc
        pc.printf("y = %d, num_readings = %d, average = %.2f, mL = %.2f\r\n", y, num_readings, average_y, result);
        pc.printf("%.2f\r\n", result);
        
        // to bluetooth
        //blue.printf("y = %d, num_readings = %d, average = %.2f, mL = %.2f\r\n", y, num_readings, average_y, result);
        blue.printf("%.2f\r\n", result);

        // reset vars
        num_readings = 0;
        total_y = 0;
    }
}