#include "mbed.h"
#include "Pixy.h"

// init board
Pixy pixy(Pixy::SPI, p11, p12, p13);
Serial pc(USBTX, USBRX);

// global vars
int num_readings = 0;
int total_y = 0;

// funcs
void get_volume(int i);

int main() {
    
    // init pixy
    pc.printf("ready\n\r");
    pixy.setSerialOutput(&pc);
    
    while (1) {
       
        // get pixy data
        uint16_t blocks;
        blocks = pixy.getBlocks();
        
        // store data
        if (blocks) {
            for (int j = 0; j < blocks; j++) {
                get_volume(pixy.blocks[j].y);
            }
        }
    }
}

void get_volume(int y) {
    
    // update data
    total_y += y;
    num_readings++;
    
    // output results
    if (num_readings > 30) {
        float average_y = (float)total_y/num_readings;
        float result = -2.0794*average_y + 351.97;
        pc.printf("y = %d, num_readings = %d, average = %f, mL = %f\r\n", y, num_readings, average_y, result);
        
        // reset vars
        num_readings = 0;
        total_y = 0;
    }
}