#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX,USBRX);

// signals
PwmOut entry_valve(p26);
PwmOut exit_valve(p25);
AnalogIn detectFill(p24);

// global vars
Timer t;
const int container_volume_mL = 10;
const int send_interval = 10000; // 10 seconds
const double ml_per_ms2ml_per_hr = (1/1000)*(1/60)*(1/60);
int UO_mL = 0;
double hourly_UO = 0;
bool updateReading = false;

// threads
void sense_container(void const *args);
Thread * sense_container_thread;
void send_readings(void const *args);
RtosTimer * send_readings_thread;

int main() {
    
    // init threads
    sense_container_thread = new Thread(sense_container);
    send_readings_thread = new RtosTimer(send_readings, osTimerPeriodic, (void *)0);
    send_readings_thread.start(send_interval);
    
    // start timer
    t.start();
    
    // record results
    while(1) {
        if (updateReading) {
            UO_mL += container_volume_mL;
            hourly_UO = (double) UO_mL/t.read_ms()*ml_per_ms2ml_per_hr;
            updateReading = false;
        }
    }
}

void sense_container(void const *args) {
    while (1) {
        // close exit and open entry
        if (!updateReadings) {
            // detect overflow code
            updateReadings = true;
            // OPEN EXIT CLOSE ENTRY
        }
    }
}

void send_readings(void const *args) {
    while (1) {
        Thread::signal_wait(RUN,osWaitForever);    
        // send data via zigby code
    }
}
