#include "mbed.h"
#include "Pixy.h"

// init board
Pixy pixy(Pixy::SPI, p11, p12, p13);
Serial pc(USBTX, USBRX);
DigitalOut pin1(p24);
DigitalOut pin2(p25);
DigitalOut led1(LED1);

#if   defined(TARGET_LPC1768)
Serial blue(p9, p10);          // TX, RX
//Serial blue(p13, p14);         // TX, RX
#elif defined(TARGET_LPC4330_M4)
Serial blue(P6_4, P6_5);         // UART0_TX, UART0_RX
//Serial blue(P2_3, P2_4);         // UART3_TX, UART3_RX
#endif

// global vars
int num_readings = 0;
int total_y = 0;
float result = 0;

// funcs
void get_volume(int i);

int main() {
    
    pin1 = 1;
     pin2 = 0;
    
    // init pixy
    pc.printf("ready\n\r");
    pixy.setSerialOutput(&pc);
    
    while (1) {
       
        // get pixy data
        uint16_t blocks;
        blocks = pixy.getBlocks(); 
        
        // store data
        if (blocks) {
            //led1 = 1;
            for (int j = 0; j < blocks; j++) {
                get_volume(pixy.blocks[j].y);
                //led1 = 1;
                if(result >= 30.0)
                {//led1 = 1;
                 pin1 = 0;
                 pin2 = 1;}
                if(result < 2.0){
                pin2 = 0;
                pin1 = 1; }
                
            
        }
            }
    }
    }


void get_volume(int y) {
    
   // led1 = 1;
    
    // update data
    total_y += y;
    num_readings++;
    
    // output results
    if (num_readings > 30) {
        float average_y = (float)total_y/num_readings;
        result = -0.2642*average_y + 38.453;
        pc.printf("Volume is : %.2f mL\r\n", result);
        blue.printf("Volume is : %.2f mL\r\n", result);
        
        
        // reset vars
        num_readings = 0;
        total_y = 0;
    }
}