#include "mbed.h"
#include "MRF24J40.h"

#include <string>

// RF tranceiver to link with handheld.
MRF24J40 mrf(p11, p12, p13, p14, p21);

// LEDs you can treat these as variables (led2 = 1 will turn led2 on!)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Timer
Timer timer;
//Timer timeout_timer;
int timeout_ms = 5000; // ms
int mole = 0;

// Serial port for showing RX data.
Serial pc(USBTX, USBRX);

// Used for sending and receiving
char txBuffer[128];
char rxBuffer[128];
int rxLen;

// funcs
int get_mole();
void led_update(int i);

// global vars
int total_time = 0;
int send_new_mole = 1;
int round = 0;

//***************** Do not change these methods (please) *****************//

/**
* Receive data from the MRF24J40.
*
* @param data A pointer to a char array to hold the data
* @param maxLength The max amount of data to read.
*/
int rf_receive(char *data, uint8_t maxLength)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};

    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }

        //pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}

/**
* Send data to another MRF24J40.
*
* @param data The string to send
* @param maxLength The length of the data to send.
*                  If you are sending a null-terminated string you can pass strlen(data)+1
*/
void rf_send(char *data, uint8_t len)
{
    //We need to prepend the message with a valid ZigBee header
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};
    uint8_t *send_buf = (uint8_t *) malloc( sizeof(uint8_t) * (len+8) );

    for(uint8_t i = 0; i < len+8; i++) {
        //prepend the 8-byte header
        send_buf[i] = (i<8) ? header[i] : data[i-8];
    }
    //pc.printf("Sent: %s\r\n", send_buf+8);

    mrf.Send(send_buf, len+8);
    free(send_buf);
}


//***************** You can start coding here *****************//
int main (void)
{
    
    pc.printf("Press any key to Start!\n");
    pc.getc();
    pc.printf("Good luck...\n");
    
    
    uint8_t channel = 15;

    //Set the Channel. 0 is default, 15 is max
    mrf.SetChannel(channel);

    //Start the timer
    timer.start();
    
    // seed rand num generator
    srand(time(NULL));

    while(true) {
        //Try to receive some data
        rxLen = rf_receive(rxBuffer, 128);
        if(rxLen > 0) {
            //Toggle the Led
            led1 = led1^1;
            pc.printf("Received: %s\r\n", rxBuffer);
            
            //if (strcmp(rxBuffer, "HIT")) {
                total_time += timer.read_ms();
                send_new_mole = 1;
                round++;
                wait(0.5);
                printf("Your current score = %d ms\r\n",total_time);
            //}
            
        }
        
        if (round == 5) {
            pc.printf("You hit 10 moles in %d seconds!\n",total_time);
            pc.printf("Play again? (Y/N)\r\n");
            char answer = pc.getc();
            if (answer == 'N') {
                exit (1);
            }
            else {
                pc.printf("Good luck...\r\n");
                round = 0;
                total_time = 0;
            }
            //exit(1);
        }
        
        if (timer.read_ms() > timeout_ms) {
            total_time += timer.read_ms();
            timer.reset();
            string msg2 = "T";
            //Add to the buffer. You may want to check out sprintf
            strcpy(txBuffer, msg2.c_str());
            //Send the buffer
            rf_send(txBuffer, strlen(txBuffer) + 1);
            pc.printf("Sent: %s\r\n", txBuffer);
            if (mole == 1) { 
                msg2 = "2";
                mole = 2;
            }
            else if (mole == 2) {
                msg2 = "3";
                mole = 3;
            } 
            else if (mole == 3) {
                msg2 = "1";
                mole = 1;
            }
            //Add to the buffer. You may want to check out sprintf
            strcpy(txBuffer, msg2.c_str());
            //Send the buffer
            rf_send(txBuffer, strlen(txBuffer) + 1);
            pc.printf("Sent: %s\r\n", txBuffer);
        }
        
        //Send some data every second
        if(send_new_mole) {
            
            send_new_mole = 0;
            
            //Reset the timer to 0
            timer.reset();

            // get mole
            string msg_out;
            mole = get_mole();
            mole = 1;
            if (mole == 1) msg_out = "1";
            if (mole == 2) msg_out = "2";
            if (mole == 3) msg_out = "3";
            led_update(mole);

            //Add to the buffer. You may want to check out sprintf
            strcpy(txBuffer, msg_out.c_str());
            //Send the buffer
            rf_send(txBuffer, strlen(txBuffer) + 1);
            pc.printf("Sent: %s\r\n", txBuffer);
                       
        }
    }
}

int get_mole() {
    return rand()%3+1;
}

void led_update(int i) {
    led2 = 0;
    led3 = 0;
    led4 = 0;
    if (i==1) led2 = 1;
    if (i==2) led3 = 1;
    if (i==3) led4 = 1;
}
