#include "mbed.h"
#include "flashwrapper.h"

int main()
{   
   /*Определение типа данных для хранения в ОЗУ*/
   typedef struct
   {
    float a;
    uint32_t b;
    uint16_t c;
    uint8_t d;       
    }bab_t;
   
   /*Обменник данными с флэш-памятью*/
   typedef union {
    /*Структурное представление для использования с ОЗУ*/
    bab_t a;    
    /*битовое представление для чтения и записи*/
    uint32_t b[sizeof(bab_t)/sizeof(uint32_t)/*+другие структуры так же*/];
    }exchanger_t;    
    
    /*Создаём экземпляр обменника данных*/
    exchanger_t bufer;    
    /*Инициализируем*/
    bufer.a.a=0.67;
    bufer.a.b=5000000;    
    bufer.a.c=60000;
    bufer.a.d=150;    
   /*Записываем и считываем обратно*/
   char q=sizeof(bab_t)/sizeof(uint32_t);
   flashWrite(0,bufer.b,q);
   for(int i=0;i<q;i++)
   {bufer.b[i]=flashRead(i*4);}
   
   /*Проверяем целостность данных*/
   printf("Value = %f\r\n",bufer.a.a);
   printf("Value = %d\r\n",bufer.a.b);
   printf("Value = %d\r\n",bufer.a.c);
   printf("Value = %d\r\n",bufer.a.d); 
   
   
}