#include "motor.h"

/**
 * Constructor.
 */
Motor::Motor(PinName _pwma,PinName _pwmb, PinName _ain0, PinName _ain1, PinName _bin0, PinName _bin1, float _speed)
: pwma(_pwma), pwmb(_pwmb), ain1(_ain1), ain0(_ain0), bin0(_bin0), bin1(_bin1) {
    Speed_L = _speed;
    Speed_R = _speed;
    init_speed = _speed;
}
 
/**
 * Destructor.
 */
Motor::~Motor() {
}

void Motor::speed_l(float sp_l){
    Speed_L = sp_l;
    
    if(Speed_L > 1){
        Speed_L = 1;
    }
    if(Speed_L < 0){
        Speed_L = 0;
    }    
}

void Motor::speed_r(float sp_r){
    Speed_R = sp_r;
    
    if(Speed_R > 1){
        Speed_R = 1;
    }
    if(Speed_R < 0){
        Speed_R = 0;
    }    
}

void Motor::speedup_l(void){
    Speed_L += 0.005; 
    if(Speed_L > 1){
        Speed_L = 1;
    }
}

void Motor::speeddown_l(void){
    Speed_L -= 0.005;
    if(Speed_L < 0){
        Speed_L = 0;
    }
}

void Motor::speedup_r(void){
    Speed_R += 0.005; 
    if(Speed_R > 1){
        Speed_R = 1;
    }
}
void Motor::speeddown_r(void){
    Speed_R -= 0.005;
    if(Speed_R < 0){
        Speed_R = 0;
    }
}

void Motor::forward(void){
    pwma = Speed_L * 0.7;
    pwmb = Speed_R;

    ain0 = 1;
    ain1 = 0;

    bin0 = 1;
    bin1 = 0;
}

void Motor::backward(void){
    
    pwma = Speed_L;
    pwmb = Speed_R;

    ain0 = 0;
    ain1 = 1;

    bin0 = 0;
    bin1 = 1;    
}

void  Motor::left(void){
    pwma = Speed_L*0.8;
    pwmb = Speed_R;

    ain0 = 1;
    ain1 = 0;

    bin0 = 1;
    bin1 = 0;
}
void Motor::right(void){
    pwma = Speed_L;
    pwmb = Speed_R*0.85;

    ain0 = 1;
    ain1 = 0;

    bin0 = 1;
    bin1 = 0;
}
void Motor::stop(void){
    pwma = init_speed;
    pwmb = init_speed;

    ain0 = 0;
    ain1 = 0;

    bin0 = 0;
    bin1 = 0;
}