#ifndef _MOTOR_H_
#define _MOTOR_H_
 
#include <mbed.h>
  
/**
 * IR receiver class.
 */
class Motor {
public:
 
    /**
     * Constructor.
     *
     * @param rxpin Pin for receive IR signal.
     */
    Motor::Motor(PinName _pwma=D6, PinName _pwmb=D5, PinName _ain0=PA_0, PinName _ain1=PA_1, PinName _bin0=PB_0, PinName _bin1=PA_4, float _speed=0.7);
    /**
     * Destructor.
     */
    ~Motor();
     
    float Speed_L, Speed_R, init_speed;
        
    PwmOut pwma;
    PwmOut pwmb;
    DigitalOut ain0;
    DigitalOut ain1;
    DigitalOut bin0;
    DigitalOut bin1;
    
    void right(void);
    void left(void);
    void forward(void);
    void backward(void);
    void stop(void);
    
    void speedup_l(void);
    void speeddown_l(void);
    void speedup_r(void);
    void speeddown_r(void);
    
    void speed_l(float sp_l);
    void speed_r(float sp_r);
};
 
#endif