#include "mbed.h"
 
#define addr1    0b01101000//KP-9250のスレーブアドレス
#define addr2    0b00001100//3軸コンパスのスレーブアドレス

I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX);
 
char cmd[2];
 
void i2c_write(int addr,char regist,char data)
{   
    cmd[0]=regist;
    cmd[1]=data;
    i2c.write(addr,cmd,2);
}
 
char i2c_read(int addr,char regist)
{
    cmd[0]=regist;
    i2c.write(addr,cmd,1);
    i2c.read(addr,cmd,1);
    return cmd[0];
}
 
int i2c_read_16bit(int addr,char registL,char registH)
{
    return (int(i2c_read(addr,registH))<<8)+int(i2c_read(addr,registL));
}
 
int main() {
//  char *tmp;
    //レジスタのリセット
    //i2c_write(addr1,0x6b,0x80);
    //スリープモードからの起動
    i2c_write(addr1,0x6b,0x00);
    wait(0.1);
    while(1){
        //Who_am_Iの確認
/*
        cmd[2] = 0x75;
        tmp = (char *)cmd[2];
        i2c.write(addr1,tmp,1);
        pc.printf("Who_am_I is %d\n\r",i2c.read(addr1,cmd,1));
 */       
        //加速度の取得        
        pc.printf("AX:%d\n\r",i2c_read_16bit(addr1,0x3B,0x3C));
        pc.printf("AY:%d\n\r",i2c_read_16bit(addr1,0x3D,0x3E));
        pc.printf("AZ:%d\n\r\n\r",i2c_read_16bit(addr1,0x3F,0x40));
/*
        //ジャイロの取得
        pc.printf("GX:%d\n\r",i2c_read_16bit(addr1,0x41,0x42));
        pc.printf("GY:%d\n\r",i2c_read_16bit(addr1,0x43,0x44));
        pc.printf("GZ:%d\n\r",i2c_read_16bit(addr1,0x45,0x46));
        pc.printf("??:%d\n\r",i2c_read_16bit(addr1,0x47,0x48)); 
*/      
        //磁気センサからのデータの取得
//      i2c_write(addr1,0x37,0x02);
/*
        i2c_write(addr2,0x0A,0x12); //AD変換した値が欲しい場合はこれ
        pc.printf("MX:%d\n\r",i2c_read_16bit(addr2,0x03,0x04));
        pc.printf("MY:%d\n\r",i2c_read_16bit(addr2,0x05,0x06));
        pc.printf("MZ:%d\n\r",i2c_read_16bit(addr2,0x07,0x08));
        pc.printf("ST2:%d\n\r",i2c_read(addr2,0x09));
*/
        wait(0.5);
    }
}