#include "mbed.h"
#include "rtos.h"
#include "mDot.h"
#include "MTSLog.h"
#include "MTSText.h"

using namespace mts;


#define REED_PORT   PA_0

// PA_0 = WKUP
// wakeup on rising edge
// reeed on PA_0 to Vss (3.3V)
// no internal pull in sleep mode
DigitalIn reed_sensor(PA_0, PullNone);

RawSerial pc(PA_2,NC);

volatile int reed_has_changed = 0;

void isr_reed_sensor_change(void) {
    reed_has_changed++;
}

main() {
    
    pc.baud(115200);
    
    pc.printf("Build: " __DATE__ ", " __TIME__"\r\n");
    
    mDot* dot = mDot::getInstance();
    dot->setLogLevel(MTSLog::TRACE_LEVEL);

    // clear the EWUP state
    if(dot->getStandbyFlag()){
        pc.printf("clearing standby flag\r\n");
        PWR->CSR &= ~PWR_CSR_EWUP;
    }

    // DigitalIn reed_sensor(REED_PORT);
    // reed_sensor.mode(PullUp);

    InterruptIn reed_sensor_change(REED_PORT);
    reed_sensor_change.fall(&isr_reed_sensor_change);
    reed_sensor_change.rise(&isr_reed_sensor_change);
    reed_sensor_change.mode(PullNone);
 
    while(1) {
        
         for(int i=0;i<10;i++) {
         
            pc.printf("Read %d, Changes: %d\r\n",reed_sensor.read(),reed_has_changed);
            wait(1.0);
         }
         
         dot->sleep((int)30, mDot::RTC_ALARM_OR_INTERRUPT, true);
    }
}