#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>

#include "payload.h"

#define REED_PORT   PA_0

// PA_0 = WKUP
// wakeup on rising edge
// reeed on PA_0 to Vss (3.3V)
// no internal pull in sleep mode
DigitalIn reed_sensor(PA_0, PullNone);
volatile int reed_has_changed = 0;

void isr_reed_sensor_change(void) {
    reed_has_changed++;
}

#define NODETYPE_OPENCLOSE  1

static std::string config_network_name = "edgelorareed2";
static std::string config_network_pass = "edgeIsGaaf";


static struct {
  uint8_t openorclosedid;
  uint8_t closedvalue;          //open=1 close-0
  
}  payloadOpenClose;



int DoNode1 (uint8_t*b,uint8_t v){
    *b++=NODETYPE_OPENCLOSE;
    *b++=v; 
    return(sizeof(payloadOpenClose));          
}


// these options must match the settings on your Conduit
// uncomment the following lines and edit their values to match your configuration

//static uint8_t config_network_addr[] = { 0x02, 0x02, 0x02, 0x02 };
  static uint8_t config_network_addr[] = { 0x02, 0x02, 0x02, 0x02 };
  
//static uint8_t config_network_nskey[] = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 };
  static uint8_t config_network_nskey[] = { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 };

// static uint8_t config_network_dskey[] = { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 };
   static uint8_t config_network_dskey[] = { 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03 };


//WBT commentout, only for 915 Mhz    static uint8_t config_frequency_sub_band = 1;

int main() {
    int32_t ret;
    mDot* dot;
    std::vector<uint8_t> data;
    
    //std::string data_str = "hello this is Edge calling!";
    std::string data_str = "hello!";
    
    DigitalIn enable(PA_3);
    
    InterruptIn reed_sensor_change(REED_PORT);
    reed_sensor_change.fall(&isr_reed_sensor_change);
    reed_sensor_change.rise(&isr_reed_sensor_change);
    reed_sensor_change.mode(PullNone);
    
    logInfo("\n\n\n\n\n");
    wait(5);
    logInfo("\n\n\n***************************************\nStarting\n");
    wait(5);
    logInfo("Started version 1.1 2 june 14.25 \n");
    logInfo(        "* Build: " __DATE__ ", " __TIME__" *\r\n");
    
     time_t seconds = time(NULL);
     uint32_t boottime=(uint32_t) seconds;
    
    
    // get a mDot handle
    dot = mDot::getInstance();
    
    // Test if we've already saved the config
    std::string configNetworkName = dot->getNetworkName();
        // Reset config if network name is different or pin is low then reset config.
    if( config_network_name.compare(configNetworkName) != 0 ) {
        // Not saved config, reset
        logInfo("Setting Config");
        // reset to default config so we know what state we're in
        dot->resetConfig();
    }
    else {
         logInfo("Resume with old  Config");
    }
    
        // clear the EWUP state
    if(dot->getStandbyFlag()){
        logInfo("clearing standby flag\r\n");
        PWR->CSR &= ~PWR_CSR_EWUP;
    }
    
    dot->setLogLevel(mts::MTSLog::TRACE_LEVEL);
   
    logError("JoinMode= %d\n", dot->getJoinMode());
    
    // print library version information
    logInfo("version: %s", dot->getId().c_str());
    
    if ((ret = dot->setNetworkName("edgeedge")) != mDot::MDOT_OK) {
            logError("failed to set network name %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
     }
 
    if ((ret = dot->setNetworkPassphrase("svensven")) != mDot::MDOT_OK) {
            logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
     }
 
    logInfo("Name: %s\r\n", dot->getNetworkName());
    dot->setPublicNetwork(true);
    

    //*******************************************
    // configuration
    //*******************************************

    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()
    
    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels
    
    //WBT logInfo("setting frequency sub band");
    // if ((ret = dot->setFrequencySubBand(config_frequency_sub_band)) != mDot::MDOT_OK) {
    //    logError("failed to set frequency sub band %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    //}
    
    
    
    std::vector<uint8_t> temp;
    
    for (int i = 0; i < 4; i++) {
        temp.push_back(config_network_addr[i]);    
    }
    
    logInfo("setting network addr");
    if ((ret = dot->setNetworkAddress(temp)) != mDot::MDOT_OK) {
        logError("failed to set network name %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    temp.clear();
    for (int i = 0; i < 16; i++) {
        temp.push_back(config_network_nskey[i]);    
    }
    
    logInfo("setting network password");
    if ((ret = dot->setNetworkSessionKey(temp)) != mDot::MDOT_OK) {
        logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    temp.clear();
    for (int i = 0; i < 16; i++) {
        temp.push_back(config_network_dskey[i]);    
    }
    
    logInfo("setting network password");
    if ((ret = dot->setDataSessionKey(temp)) != mDot::MDOT_OK) {
        logError("failed to set network password %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    logInfo("setting TX spreading factor");
    if ((ret = dot->setTxDataRate(mDot::SF_10)) != mDot::MDOT_OK) {
        logError("failed to set TX datarate %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    // WBT DONT request receive confirmation of packets from the gateway
    //logInfo("WBT DONT enabling ACKs");
    //if ((ret = dot->setAck(0)) != mDot::MDOT_OK) {
        //logError("failed to NOT enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    //}
    
    /*
    logInfo("WBT DO enabling ACKs");
    if ((ret = dot->setAck(1)) != mDot::MDOT_OK) {
        logError("failed to  enable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    */
    logInfo("WBT UNABLE ACKs");
    if ((ret = dot->setAck(0)) != mDot::MDOT_OK) {
        logError("failed to  unnable ACKs %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
    
    //     TODO   Command(dot, "Rx Output", "AT+RXO", "Set the Rx output type (0:hexadecimal, 1:raw)"), _serial(serial)
    
    
  
  /*  
    logInfo("WBT SET JOIN");
    if ((ret = dot->setJoinMode(mDot::MANUAL)) != mDot::MDOT_OK) {
        logError("failed to set to manual %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
    }
      
    logInfo("WBT GET JOIN");
    ret = dot->getJoinMode();
    logError("WBTGET JOIN %d\n", ret);

    */
     
    
    // save this configuration to the mDot's NVM
    logInfo("saving config");
    if (! dot->saveConfig()) {
        logError("failed to save configuration");
    }
    //*******************************************
    // end of configuration
    //*******************************************
/*
    // attempt to join the network
    logInfo("joining network");
    while ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
        logError("failed to join network %d:%s", ret, mDot::getReturnCodeString(ret).c_str());
        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        osDelay(std::max((uint32_t)1000, (uint32_t)dot->getNextTxMs()));
        
        //WBT
        wait(60);
    }
    */

     uint32_t now = (uint32_t)seconds - boottime;
    
    
    //debugformat data for sending to the gateway
    for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
        data.push_back((uint8_t) *it);
    
    while (true) {
        
        //for now fake the absolute value of reed_has_changed into battery level
        //(to avoid that only 0/1 are valid values
        
        //setBatteryLevel(reed_has_changed);
        //getDataAndUpdate(&data);
        
        // meet
        logInfo("Reed = %d", reed_has_changed);
        
        
        
        // send the data to the gateway
        if ((ret = dot->send(data)) != mDot::MDOT_OK) {
            logError("failed to send err=%d errs=%s", ret, mDot::getReturnCodeString(ret).c_str());
        } else {
            logInfo("successfully sent data to gateway");
        }
        
        // inpired by https://developer.mbed.org/teams/MultiTech/code/mDot_AT_firmware/file/6a12bf1f6723/CommandTerminal/CmdReceiveOnce.cpp
        //if we asked for an ack, then the send will have returned with the ack recption and data is ready ???
        if (dot->recv(data) == mDot::MDOT_OK) {
                printf("data received=\n");
                //printf("data received= %s\n", dot->getRxOutput().c_str(););    
        }
                
        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        //osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
        
        //deepsleep
        dot->sleep((int)60, mDot::RTC_ALARM_OR_INTERRUPT, true);
    }
    return 0;
}
