#include "mbed.h"
#include "rtos.h"
#include <string>
#include <vector>
#include "payload.h"
#include "Ticker.h"

// RTOS needs RawSerial (and not Serial)
RawSerial pc(USBTX,USBRX);
Ticker sender_ticker;
std::vector<uint8_t> data_to_send(sizeof(Payload));

#define SEND_INTERVAL   0.5
#define UPDATE_INTERVAL 1

void sender(void) {
    
    pc.printf("---- checking changes: ");
    
    // carefull... do not use if(hasChanges())
    int changes = hasChanges();
    
    if(changes) {
        
        getDataAndUpdate(&data_to_send);
        
        pc.printf("sending: ");
        for(int i=0;i<sizeof(Payload);i++) {
            pc.printf("%02x",(unsigned int)data_to_send.at(i));
        }
    } else {
        pc.printf("no change");
    }
    pc.printf("\r\n");
}

int main() {

    unsigned char battery_level = 255;
    
    pc.baud(115200);
    pc.printf("\r\n\r\n********************************\r\n");
    pc.printf(        "*                              *\r\n");
    pc.printf(        "*        Edge Payload Test     *\r\n");
    pc.printf(        "*                              *\r\n");
    pc.printf(        "* Build: " __DATE__ ", " __TIME__" *\r\n");
    pc.printf(        "********************************\r\n\r\n");
    
    pc.printf("sizeof(char) = %d\r\n",sizeof(char));
    pc.printf("sizeof(short) = %d\r\n",sizeof(short));
    pc.printf("sizeof(int) = %d\r\n",sizeof(int));
    pc.printf("sizeof(long) = %d\r\n",sizeof(long));
     
    
    pc.printf("Node ID:    %d\r\n",NODE_ID);
    pc.printf("Node STATE: %d\r\n",NODE_STATE);
    
    sender_ticker.attach(&sender, SEND_INTERVAL);
    
    pc.printf("\r\n\r\npayload size: %d bytes\r\n",sizeof(Payload));
    
    pc.printf("changing battery_level to %d\r\n",battery_level);
    setBatteryLevel(battery_level);
        
    while(1) {
        
        Thread::wait(UPDATE_INTERVAL*1000);
        pc.printf("changing reed_sensor_value to 1\r\n");
        setReedSensorValue(1);
        Thread::wait(UPDATE_INTERVAL*1000);
        pc.printf("changing change_in_last_ack_window to 1\r\n");
        setChangeInLastAckWindow(1);
        Thread::wait(UPDATE_INTERVAL*1000);
        pc.printf("changing reed_sensor_value to 1\r\n");
        setReedSensorValue(1);
        Thread::wait(UPDATE_INTERVAL*1000);
        pc.printf("changing reed_sensor_value to 0\r\n");
        setReedSensorValue(0);
        Thread::wait(UPDATE_INTERVAL*1000);
        pc.printf("changing change_in_last_ack_window to 0\r\n");
        setChangeInLastAckWindow(0);
        Thread::wait(UPDATE_INTERVAL*1000);
        battery_level--;
        pc.printf("changing battery_level to %d\r\n",battery_level);
        setBatteryLevel(battery_level);
        if(battery_level<250) {
            pc.printf("changing low_battery to 1\r\n");
            setLowBattery(1);
        }
    }
}