// automagically generated (version 20160519)
// by: http://iot.edgetech.nl/iot/node/includeFile?node=0x01
// on: 20160519
#include <Semaphore.h>

enum NodeStates { development = 0, preproduction = 1, production = 2};
#define NODE_ID                     0x01
#define NODE_STATE           development

#define CONTACT_NOACK_MIN          10000
#undef  CONTACT_NOACK_MAX   
#define CONTACT_ACK_MIN          3600000
#define CONTACT_ACK_MAX          3600000

#define CONTACT_MAX_TOTAL_PER_DAY    100

#pragma pack(push, 1)
typedef struct payloadvalues{
  unsigned char node_id;
  unsigned char reed_sensor_value: 1;
  unsigned char change_in_last_ack_window: 1; 
  unsigned char low_battery: 1;
  unsigned char battery_level;
}  PayloadValues;

typedef union payload {
   PayloadValues values;
   char b[sizeof(PayloadValues)];
} Payload;

Payload payload_new = {NODE_ID,0,0};
Payload payload_last = {NODE_ID,0,0};
#pragma pack(pop)

Semaphore payload_protect(1);

int setReedSensorValue(unsigned char value) {
    if(value>1) {
        return(0);
    }
    payload_protect.wait();
    payload_new.values.reed_sensor_value = value;
    payload_protect.release();
    return(1);
}

int setChangeInLastAckWindow(unsigned char value) {
    if(value>1) {
        return(0);
    }
    payload_protect.wait();
    payload_new.values.change_in_last_ack_window = value;
    payload_protect.release();
    return(1);
}

int setLowBattery(unsigned char value) {
    if(value>1) {
        return(0);
    }
    payload_protect.wait();
    payload_new.values.low_battery = value;
    payload_protect.release();
    return(1);
}

int setBatteryLevel(unsigned char value) {
    payload_protect.wait();
    payload_new.values.battery_level = value;
    payload_protect.release();
    return(1);
}

int hasChanges() {
    payload_protect.wait();
    for(int i=1;i<sizeof(Payload);i++) {
        if(payload_new.b[i]!=payload_last.b[i]) {
            payload_protect.release();
            return(1);
        }
    }
    payload_protect.release();
    return(0);
}

void getDataAndUpdate(std::vector<uint8_t> *b) {
    payload_protect.wait();
    std::copy(payload_new.b, payload_new.b + sizeof(Payload), b->begin());
    std::copy(payload_new.b, payload_new.b + sizeof(Payload), payload_last.b);
    payload_protect.release();
}
    
