#include "mbed.h"
#include "rtos.h"
#include "mDot.h"


#define GPIO_PORT   PA_0

RawSerial pc(PA_2,NC);

// results:
//              default  pullup  pulldown  pullnone  open drain
// battery + close 0.00    0.00      0.00      0.00        0.00
// battery + open  1.55    3.01      0.01  drifting    drifting
// mdk + open      0.00    0.00      0.00      0.00        0.00
// mdk + close     3.30    3.21      2.26      3.12        3.30
//
// conclusion: mdk has something connected to PA_0

// https://developer.mbed.org/users/n0tform3/code/HelloWorld_IKS01A1/docs/1c6281289d67/stm32f4xx_8h_source.html


void print_gpio_pa0_config(void) {

        pc.printf("MODER %x\r\n",GPIOA->MODER&0x3);
        pc.printf("OTYPER %x\r\n",GPIOA->OTYPER&0x1);
        pc.printf("OSPEEDR %x\r\n",GPIOA->OSPEEDR&0x3);
        pc.printf("PUPDR %x\r\n",GPIOA->PUPDR&0x3);
        pc.printf("IDR %x\r\n",GPIOA->IDR&0x1);
        pc.printf("ODR %x\r\n",GPIOA->ODR&0x1);
        pc.printf("BSRR %x\r\n",GPIOA->BSRR&0x1);
        pc.printf("LCKR %x\r\n",GPIOA->LCKR&0x1);
        pc.printf("AFR[0] %x\r\n",GPIOA->AFR[0]&0xf);
}
    
main() {
    
   pc.baud(115200);
    
    pc.printf("Build: " __DATE__ ", " __TIME__"\r\n");
    
    DigitalIn gpio_sensor(GPIO_PORT);
    pc.printf("pin mode: default\r\n");
    print_gpio_pa0_config();
    wait(10);
    
    // uint32_t lock = GPIOA->LCKR;
    // pc.printf("Read %x\r\n",lock);
    
    while(1) {
         
         gpio_sensor.mode(PullUp);
         pc.printf("pin mode: pullup\r\n");
         print_gpio_pa0_config();
         wait(10);
        
         gpio_sensor.mode(PullDown);
         pc.printf("pin mode: pulldown\r\n");
         print_gpio_pa0_config();
         wait(10);
         
         gpio_sensor.mode(PullNone);
         pc.printf("pin mode: pullnone\r\n");
         print_gpio_pa0_config();
         wait(10);
         
         gpio_sensor.mode(OpenDrain);
         pc.printf("pin mode: opendrain\r\n");
         print_gpio_pa0_config();
         wait(10);
    }
}