#include "mbed.h"
 
// veranderd!
 
// Read temperature from TH06

// p6   PA_8 / XBEE_PWM0 / XBEE_RSSI / I2C_SCL  D15
// p7   PC_9 / XBEE_PWM1 / I2C_SDA              D14
I2C i2c(PC_9,PA_8);

const int addr = 0x80;

int main() {
    char cmd[2];
    
    while (1) {
        cmd[0] = 0xf3;
        i2c.write(addr, cmd, 1);
 
        wait(0.5);
 
        i2c.read(addr, cmd, 2);
 
        float temp_code = (cmd[0]<<8)|cmd[1];
        float temp = 175.72*temp_code/65535.0-46.85;
        
        printf("Temp = %.2f\r\n", temp);
    }
}