#include "mbed.h"
#include "NeoStrip.h"

DigitalOut myled(LED1);
AnalogIn ir(p20);
Serial pc(USBTX, USBRX);

#define N 59

NeoStrip strip(p18, N);

void blinkOn();
void blinkOff();


void blinkOn()
{
    for (int i = 0; i < N; i++)
    {
        if (i % 2)
            strip.setPixel(i, 0xff, 0, 0);   
        else
            strip.setPixel(i, 0, 0, 0);  
    }
    wait_ms(50);
   strip.write();
}

void blinkOff()
{
    for (int i = 0; i < N; i++)
    {
        strip.setPixel(i, 0, 0, 0);   
    }
    wait_ms(60);
   strip.write();
}

int main() {
    
    float buffer [10];
    
    while(1)
    {
        for (int i = 0; i < 10; i++)
        {
            float val;
            val = 21/ir;
            buffer[i] = val;
            float sum = 0;
            for (int j = 0; j < 10; j++)
            {
                sum += buffer[j];
            }
            float avg = sum/10;
            pc.printf("%f\r\n", avg);
            
            if (avg < 70)
            {
                blinkOn();
                wait_ms(100);
                blinkOff();
                wait_ms(100);            
                blinkOn();
                wait_ms(100);
                blinkOff();
                wait_ms(100);              
                blinkOn();
                wait_ms(100);
                blinkOff();
                wait_ms(100); 
                
            }
        }
    }
    
}
