#include "mbed.h"
#include "NeoStrip.h"


#define N 59

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p13,p14);
DigitalOut myled1(LED1);

NeoStrip strip(p18, N);

void blinkOn();
void blinkOff();

Timer t;
void callback(){
   t.reset();
   //reply ack
   device.putc('A');
   //clear serial buffer
   while(device.readable()) device.getc();
   myled1=1;
   t.start();
   blinkOff();
}


void blinkOn()
{
    for (int i = 0; i < N; i++)
    {
        if (i % 2)
            strip.setPixel(i, 0xff, 0, 0);   
        else
            strip.setPixel(i, 0, 0, 0);  
    }
    wait_ms(50);
   strip.write();
}

void blinkOff()
{
    for (int i = 0; i < N; i++)
    {
        strip.setPixel(i, 0, 0, 0);   
    }
    wait_ms(60);
   strip.write();
}
int main() {
       
    strip.setBrightness(.1);
    
    blinkOn();
    wait_ms(200);
    blinkOff();
    

   //set mbed baud rate the same as BLE mini baud rate
   device.baud(57600);
   device.attach(&callback);
   
   //wait until device is connected;
   while(!device.readable()){}
   
   while(1){
       if(t.read_ms()>3000) {
            
            blinkOn();
            wait_ms(200);
            blinkOff();
            wait_ms(200);            
            blinkOn();
            wait_ms(200);
            blinkOff();
            wait_ms(200);              
            blinkOn();
            wait_ms(200);
            blinkOff();
            wait_ms(200); 
       }
       
   }

}