#include "mbed.h"
#include "NeoStrip.h"
#include "Arrows.h"

#define TURN_LEFT 76
#define TURN_RIGHT 86
#define STOP 96 


#define N 128
#define PATTERNS 4


void patternLeft();
void patternRight();
void patternStop();
void patternNone();

// array of function pointers to the various patterns
void (*patterns[])(void) = {&patternLeft, &patternRight, &patternStop, &patternNone};

Serial pc(USBTX, USBRX); // tx, rx
Serial device(p13,p14); //serial connection for BLE chip, tx,rx

NeoStrip strip(p18, N);

int main() {
   unsigned char command;
   int pattern = 3;
   //set mbed baud rate the same as BLE mini baud rate
   device.baud(57600);
   
   strip.setBrightness(.1);
   
   //simple polling demonstrate serial communication
   while(1) {
       
       if(device.readable()) {
           command=device.getc();
           switch(command){
               case TURN_LEFT:
               pattern = 0;
               break;
               case TURN_RIGHT:
               pattern = 1;
               break;
               case STOP:
               pattern = 2;
               break;
               default:
               break;
           }
           
           //blink 5 times
           patterns[pattern]();
           strip.write();
           wait_ms(500);
           patterns[3]();
           strip.write();
           wait_ms(500);
           patterns[pattern]();
           strip.write();
           wait_ms(500);
           patterns[3]();
           strip.write();
           wait_ms(500);
           patterns[pattern]();
           strip.write();
           wait_ms(500);
           patterns[3]();
           strip.write();
           wait_ms(500);
           patterns[pattern]();
           strip.write();
           wait_ms(500);
           patterns[3]();
           strip.write();
           
       } else {
           pattern = 3;
       }
       
       //for (int i = 0; i < 3; i++)
       //{
          // pattern = i;
       
          
       
       //}
   }
   
}


void patternLeft()
{
    for (int i = 0; i < N; i++)
    {
        if (maskLeft128[i] == 1)
            strip.setPixel(i, 0, 0xff, 0);   
        else
            strip.setPixel(i, 0);  
    }
}

void patternRight()
{
    for (int i = 0; i < N; i++)
    {
        if (maskRight128[i] == 1)
            strip.setPixel(i, 0, 0xff, 0);   
        else
            strip.setPixel(i, 0);  
    }
}

void patternStop()
{
    for (int i = 0; i < N; i++)
    {
        if (maskStop128[i] == 1)
            strip.setPixel(i, 0xff, 0, 0);   
        else
            strip.setPixel(i, 0);  
    }
}

void patternNone()
{
    for (int i = 0; i < N; i++)
    {
        strip.setPixel(i, 0);  
    }
}