#include "mbed.h"
#include "NeoStrip.h"
#include "text.h"
#define N 128
#define PATTERNS 4
#include <string>
#include "helper.h"
//callback function for incoming serial communication
void callback();
//necessary functions for distanceDemo and bikeDemo
void blinkOn();
void blinkOff();
void patternLeft();
void patternRight();
void patternStop();
void patternNone();
void distanceDemo();

//necessary functions for Animation Demo
int hueToRGB(float h);
void rainBow();
void fillBlue();
void progressBar(bool);
void putChar(int row, int col, char ch, int color);
void putString(std::string);
void loopAscii(int count);
void MarioBox();
void drawBox(int row);void emptyBox(int row);
void putCharV(int row, int col, char ch, int color);




//hardware initilization
NeoStrip strip(p18, N);
Serial device(p13,p14);
AnalogIn ir(p20);


//variable initilization
Timer t;
int chars[128];
char ch = 'A';
std::string emoji[9] = {"*_*", "^_^", "$_$", ">_<", "=_=", "+_=", ":)", ":(", ":3"};
void (*patterns[])(void) = {&patternLeft, &patternRight, &patternStop, &patternNone};
int bikeDir;

int main()
{    
    float bright = 0.2; // 20% is plenty for indoor use
    strip.setBrightness(bright);    // set default brightness
    //setup serial device
    device.baud(57600);
    device.attach(&callback);

    //wait until phone is connected
    progressBar(false);
    while(1){
        if(device.readable()) break; 
    }
    //progress Bar light up on T-shirt to demonstrate connection is established.
    
    progressBar(true);
    //ready for commands, clear serael buffer
    while(device.readable()) device.getc();
    
    //phone is disconnected, flash red light warning
    while(1){
    if(t.read_ms()>3000){
        blinkOn();
        wait_ms(200);
        blinkOff();
        wait_ms(200);
    }
    
    }



}


void callback(){   
    t.reset();
    t.stop();
   switch(device.getc()){
    
       case PhoneDemo:
       //discard second byte
       device.getc();      
       //reply ack
       device.putc('P');
       t.start();
       break;
       
       case MusicDemo:
       device.getc();
       rainBow();
       break;
       
       case DistanceDemo:
       device.getc();    
       device.putc('D');  
       break;
       
       case AnimationOneDemo:
       device.getc();
       MarioBox();
       break;
       
       case AnimationTwoDemo:
       device.getc();      
       for(int i=0;i<8;i++){
        putString(emoji[i]);
       }
       
       
       break;
       
       case AnimationThreeDemo:
       device.getc();
       for(int i=0;i<126;i++) loopAscii(i);
       break;
       
       case BikeDemo:
       bikeDir=device.getc();
       if (bikeDir==LEFT)  patternLeft();
       else if(bikeDir==RIGHT) patternRight();
       else if(bikeDir==STOP)patternStop();
       else patternNone();
       break;
       
       default:
       break;
   }
   

}


// display a shifting rainbow, all colors have maximum
// saturation and value, with evenly spaced hue
void rainBow()
{
    static float dh = 360.0 / N;
    static float x = 0;

    //rainbow three times
for(int j=0;j<3;j++){

    for (int i = 0; i < N; i++)
        strip.setPixel(i, hueToRGB((dh * i) - x));
    
    x += 1;
    if (x > 360)
        x = 0;

}


}



// Converts HSV to RGB with the given hue, assuming
// maximum saturation and value
int hueToRGB(float h)
{
    // lots of floating point magic from the internet and scratching my head
    float r, g, b;
    if (h > 360)
        h -= 360;
    if (h < 0)
        h += 360;
    int i = (int)(h / 60.0);
    float f = (h / 60.0) - i;
    float q = 1 - f;
    
    switch (i % 6)
    {
        case 0: r = 1; g = f; b = 0; break;
        case 1: r = q; g = 1; b = 0; break;
        case 2: r = 0; g = 1; b = f; break;
        case 3: r = 0; g = q; b = 1; break;
        case 4: r = f; g = 0; b = 1; break;
        case 5: r = 1; g = 0; b = q; break;
        default: r = 0; g = 0; b = 0; break;
    }
    
    // scale to integers and return the packed value
    uint8_t R = (uint8_t)(r * 255);
    uint8_t G = (uint8_t)(g * 255);
    uint8_t B = (uint8_t)(b * 255);

    return (R << 16) | (G << 8) | B;
}

void fillBlue(){
    for(int i = 0; i < N; i++){
        chars[i] = 0x122446;
    }   
}




void putChar(int row, int col, char ch, int color){
        for(int r = 0; r < 8; r++){
            for(int c = 0; c < 6; c++){
                if(fontdata_6x8[ch * 48 + r * 6 +c]){
                    int idx = getIndex(row+r, col+c);
                    if(idx != -1)
                        chars[idx] = color; 
                }
            }
    }
}
void putCharV(int row, int col, char ch, int color){
        for(int r = 0; r < 8; r++){
            for(int c = 0; c < 6; c++){
                if(fontdata_6x8[ch * 48 + r * 6 +c]){
                    int idx = (row + r) *8 +( col +c);
                    if(idx != -1)
                        chars[idx] = color; 
                }
            }
    }
}

void MarioBox(){
        int color = 0xffff00;
    //    int red = 0xff0000;
        
        drawBox(8);
        strip.setPixels(0, N, chars);
        strip.write();      
        wait(5);

        for(int i = 1; i < 3; i++){
            fillBlue();
            drawBox(8-i);
            strip.setPixels(0, N, chars);
            strip.write();      
            wait(0.3);
        }       
        for(int i = 0; i < 3; i++){
            fillBlue();
            drawBox(6 + i);
            strip.setPixels(0, N, chars);
            strip.write();      
            wait(0.3);
        }
        fillBlue();
        emptyBox(8);
        putChar(0,0,'0',color);
        strip.setPixels(0, N, chars);
        strip.write();
        wait(30);       
}
void putString(std::string str){
    int color = 0xffff00;
    for(int i = 0; i < str.length(); ++i){
        putChar(0,5*i,str[i], color);       
    }   
    strip.setPixels(0, N, chars);
    strip.write();

}

void loopAscii(int count){
    int color = 0xffff00;
    putChar(0,0,ch+count,color);
    putChar(0,6,ch+count+1,color);
    strip.setPixels(0, N, chars);
    strip.write();
}

void drawBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
    putCharV(row,0,'?',0xffff00);   
}
void emptyBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
}
void progressBar(bool up){
    int index;
    int init;
    int increment;
    int color;
    if(up == true){
         init = 0;
         increment = 1;
         color = 0x122446;
    }else {
         init = 15;
         increment = -1;
        fillBlue();
         color = 0x000000;
    }
    
    for(int x = 0; x < 16 ; x++){
        
        for (int j = 0; j < 8; j++){
            index = getIndex(j,init + increment * x);
            chars[index] = color;
        }
    strip.setPixels(0, N, chars);
    strip.write();
        wait(1);
    }
}



void patternLeft()
{
    for (int i = 0; i < 59; i++)
    {
        if (maskLeft[i] == 1)
            strip.setPixel(i, 0, 0xff, 0);   
        else
            strip.setPixel(i, 0);  
    }
}
 
void patternRight()
{
    for (int i = 0; i < 59; i++)
    {
        if (maskRight[i] == 1)
            strip.setPixel(i, 0, 0xff, 0);   
        else
            strip.setPixel(i, 0);  
    }
}
 
void patternStop()
{
    for (int i = 0; i < 59; i++)
    {
        if (maskStop[i] == 1)
            strip.setPixel(i, 0xff, 0, 0);   
        else
            strip.setPixel(i, 0);  
    }
}
 
void patternNone()
{
    for (int i = 0; i < 59; i++)
    {
        strip.setPixel(i, 0);  
    }
}



void blinkOn()
{
    for (int i = 0; i < N; i++)
    {
        if (i % 2)
            strip.setPixel(i, 0xff, 0, 0);   
        else
            strip.setPixel(i, 0, 0, 0);  
    }
    wait_ms(50);
   strip.write();
}
 
void blinkOff()
{
    for (int i = 0; i < N; i++)
    {
        strip.setPixel(i, 0, 0, 0);   
    }
    wait_ms(60);
   strip.write();
}



void distanceDemo(){
    float temp[10];
    for (int i = 0; i < 10; i++)
            {
                float val;
                val = 21/ir;
                temp[i] = val;
                float sum = 0;
                for (int j = 0; j < 10; j++)
                {
                    sum += temp[j];
                }
                float avg = sum/10;            
                if (avg < 70)
                {
                    blinkOn();
                    wait_ms(100);
                    blinkOff();
                    wait_ms(100);            
                    blinkOn();
                    wait_ms(100);
                    blinkOff();
                    wait_ms(100);              
                    blinkOn();
                    wait_ms(100);
                    blinkOff();
                    wait_ms(100); 
                
                }
            }
       
}


