#include "mbed.h"
#include "NeoStrip.h"
#include "text.h"
#define N 128
#define PATTERNS 4
#include <string>
#include "helper.h"


NeoStrip strip(p18, N);

//callback function for incoming serial communication
void callback();
//necessary functions for distanceDemo and bikeDemo
void blinkOn();
void blinkOff();
void patternLeft();
void patternRight();
void patternStop();
void patternNone();
void distanceDemo();
void rainBow();
void emojiDemo();
//necessary functions for Animation Demo
void fillBlue();
void progressBar(bool);
void putChar(int row, int col, char ch, int color);
void putString(std::string);
void loopAscii();
void MarioBox();
void drawBox(int row);void emptyBox(int row);
void putCharV(int row, int col, char ch, int color);
int getIndex(int r, int c);



//hardware initilization
Serial device(p13,p14);
AnalogIn ir(p20);
Serial pc(USBTX,USBRX);

//variable initilization
Timer t;
int chars[128];
std::string emoji[9] = {"*_*", "^_^", "$_$", ">_<", "=_=", "+_=", ":)", ":(", ":3"};
void (*patterns[])(void) = {&patternLeft, &patternRight, &patternStop, &patternNone};
int bikeDir;
char ch = 'A';

int main()
{    
//    std::string emoji[9] = {"*_*", "^_^", "$_$", ">_<", "=_=", "+_=", ":)", ":(", ":3"};
    float bright = 0.2; // 20% is plenty for indoor use
    strip.setBrightness(bright);    // set default brightness

    //setup serial device
    device.baud(57600);    
    device.attach(&callback);

    //wait until phone is connected
    while(1){
        if(device.readable()) break; 
    }
    pc.printf("Device connected\n");

    //ready for commands, clear serael buffer
    while(device.readable()) device.getc();
    pc.printf("Device ready for commands;\n");
    //phone is disconnected, flash red light warning
    while(1){
        if(t.read_ms()>3000){
            pc.printf("time passed i %d\n",t.read_ms());
            blinkOn();
        //progressBar(true);
            wait_ms(200);
            blinkOff();
      //  wait_ms(200);
        }
        wait(5);
    }



}


void callback(){   
    pc.printf("new commands arrive \n");
    t.reset();
    switch(device.getc()){

     case PhoneDemo:
     pc.printf("Lost Phone Demo\n");
     while(device.readable()) device.getc();
       //reply ack
     device.putc('P');
     t.start();
     break;

     case MusicDemo:
     pc.printf("Music Demo\n");
     rainBow();
     //progressBar(true);
     //progressBar(false);
     break;

     case DistanceDemo:
     pc.printf("Distance Demo\n");
     device.putc('D');
     distanceDemo();  
     break;

     case AnimationOneDemo:
     MarioBox();
     break;

     case AnimationTwoDemo:
     pc.printf("Emoji Demo\n");
     emojiDemo();
     break;

    case AnimationThreeDemo:
    pc.printf("ascii demo\n");
    loopAscii();
     break;

 case LEFT:
 pc.printf("left arrow\n");
 patternLeft();
 break;

 case RIGHT:
 pc.printf("right arrow\n");

 patternRight();
 break;       

 case STOP:
 pc.printf("stop\n");

 patternStop();
 break;

 default:
 break;
}


}







void fillBlue(){
    for(int i = 0; i < N; i++){
        chars[i] = 0x122446;
    }   
}

void putChar(int row, int col, char ch, int color){
    for(int r = 0; r < 8; r++){
        for(int c = 0; c < 6; c++){
            if(fontdata_6x8[ch * 48 + r * 6 +c]){
                int idx = getIndex(row+r, col+c);
                if(idx != -1)
                    chars[idx] = color; 
            }
        }
    }
}
void putCharV(int row, int col, char ch, int color){
    for(int r = 0; r < 8; r++){
        for(int c = 0; c < 6; c++){
            if(fontdata_6x8[ch * 48 + r * 6 +c]){
                int idx = (row + r) *8 +( col +c);
                if(idx != -1)
                    chars[idx] = color; 
            }
        }
    }
}

void MarioBox(){
    int color = 0xffff00;
    //    int red = 0xff0000;

    drawBox(8);
    strip.setPixels(0, N, chars);
    strip.write();      
    wait(5);

    for(int i = 1; i < 3; i++){
        fillBlue();
        drawBox(8-i);
        strip.setPixels(0, N, chars);
        strip.write();      
        wait(0.3);
    }       
    for(int i = 0; i < 3; i++){
        fillBlue();
        drawBox(6 + i);
        strip.setPixels(0, N, chars);
        strip.write();      
        wait(0.3);
    }
    fillBlue();
    emptyBox(8);
    putChar(0,0,'0',color);
    strip.setPixels(0, N, chars);
    strip.write();
    wait(5);    
    strip.clear();
    strip.write();

}
void putString(std::string str){
    int color = 0xffff00;
    for(int i = 0; i < str.length(); ++i){
        putChar(0,5*i,str[i], color); 
        strip.setPixels(0, N, chars);
    }   
    strip.write();
    wait_ms(100);
}

void loopAscii(){
    int color = 0xffff00;
    char ch = 'A';
    int count = 50;
    
    for(int i = 0; i < count; i+=2) {
        putChar(0,0,ch+i,color);
        putChar(0,7,ch+i+1,color);
        strip.setPixels(0, N, chars);
        strip.write();    
        wait_ms(200);
    }       

}

void drawBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
    putCharV(row,0,'?',0xffff00);   
}
void emptyBox(int row){
    for(int i = 0; i < 64; ++i)
        chars[row*8 + i] = 0x000000;
}
void progressBar(bool up){
    int index;
    int init;
    int increment;
    int color;
    if(up == true){
       init = 0;
       increment = 1;
       color = 0x122446;
   }else {
       init = 15;
       increment = -1;
       fillBlue();
       color = 0x000000;
   }

   for(int x = 0; x < 16 ; x++){

    for (int j = 0; j < 8; j++){
        index = getIndex(j,init + increment * x);
        chars[index] = color;
    }
    strip.setPixels(0, N, chars);
    strip.write();
    wait_ms(200);
}
}


void rainBow(){
    int index;
    unsigned int black = 0x000000;
    unsigned int color[7] = {0x5b00ff,0xff0d19, 0xf0ff03, 0x17ff29, 0x1fffee,0x0d65ff, 0xfb12ff};
    int init = 0;
    int increment = 1;

    for(int x = 0; x < 16 ; x++){
        for (int j = 0; j < 8; j++){
            index = getIndex(j,init + increment * x);
            chars[index] = color[index%7];            
        }
        strip.setPixels(0, N, chars);
        strip.write();
        wait_ms(200);
    }

    for(int x = 15; x >= 0 ; x--){
        for (int j = 0; j < 8; j++){
            index = getIndex(j,init + increment * x);
            chars[index] = black;            
        }

        strip.setPixels(0, N, chars);
        strip.write();
        wait_ms(200);
    }

}   



void patternLeft()
{
    for(int j=0;j<3;j++){
        for (int i = 0; i < N; i++)
        {
            if (maskLeft128[i] == 1)
                chars[i]=0x00FF00;
            else
                chars[i]=0x000000;
        }
    
        strip.setPixels(0, N, chars);
        strip.write();
        wait_ms(200);
        strip.clear();
        strip.write();
        wait_ms(200);

    }
}

void patternRight()
{
    for(int j=0;j<3;j++){
        for (int i = 0; i < N; i++)
        {
            if (maskRight128[i] == 1)
                chars[i]=0x00FF00;
            else
                chars[i]=0x000000;
        }
        strip.setPixels(0, N, chars);
        strip.write();
        wait_ms(200);
        strip.clear();
        strip.write();
        wait_ms(200);

    }

}

void patternStop()
{
    for(int j=0;j<3;j++){
        for (int i = 0; i < N; i++)
        {
            if (maskStop128[i] == 1)
                chars[i]=0xFF0000;
            else
                chars[i]=0x000000;
        }
        strip.setPixels(0, N, chars);
        strip.write();
        wait_ms(200);
        strip.clear();
        strip.write();
        wait_ms(200);

    }

}

void patternNone()
{
    strip.clear();
}



void blinkOn()
{
    strip.clear();
    for (int i = 0; i < N; i++)
    {
        chars[i]=0xFF0000;
    }

    strip.setPixels(0, N, chars);
    strip.write();
    wait_ms(200);
}

void blinkOff()
{
    strip.clear();
    for (int i = 0; i < N; i++)
    {
        chars[i]=0x000000;
    }
    strip.setPixels(0, N, chars);
    strip.write();
    wait_ms(200);
}



void distanceDemo(){
    float val = 21/ir;  
    pc.printf("dist avg=%f\n",val);       
    
    if(val<70) {
        blinkOn();
        wait_ms(200);
        blinkOff();
    }

}

void emojiDemo(){
     for(int i=0;i<8;i++){
        putString(emoji[i]);
        wait_ms(200);
        strip.write();
        wait_ms(200);
        strip.clear();
        strip.write();
        wait_ms(200);
    }    
}


int getIndex(int r, int c){
    if(c < 8){
        return (r * 8 + c);
    }else if(c > 15){
        return -1;      
    }
    else{
        return (64 + r * 8 + (c-8));
    }
}