#include "uLCD_4DGL.h"
#include "mbed.h"
#include "rtos.h"
#include "SongPlayer.h"

uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
AnalogOut DACout(p18);
DigitalOut myled(LED1);
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);

float note[18]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5, 0.0
                };
float duration[18]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48, 0.0
                    };

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;

// global variables
int i = 0;
int ix = 0;

void drawairplane(int x, int y) {
    uLCD.filled_rectangle(x, y+7, x+27, y+13, WHITE);
    uLCD.filled_rectangle(x, y, x+4, y+6, BLUE);
    uLCD.filled_rectangle(x, y+14, x+4, y+20, BLUE);
    uLCD.filled_rectangle(x+16, y-6, x+20, y+6, BLUE);
    uLCD.filled_rectangle(x+16, y+14, x+20, y+26, BLUE);
    uLCD.filled_rectangle(x+20, y+9, x+27, y+11, BLUE);
    uLCD.filled_rectangle(x+15, y+9, x+17, y+11, BLUE);
    uLCD.filled_rectangle(x+10, y+9, x+12, y+11, BLUE);
    uLCD.filled_rectangle(x+5, y+9, x+7, y+11, BLUE);
}

// Thread 1
// RGB LED
void thread1(void const *args)
{
    while(true) {         // thread loop
        if (i < 10) {
            RGBLED_r = 0.0;
            RGBLED_g = (float) i / 10;
            RGBLED_b = 0.0;
        } else if (10 <= i && i < 20) {
            RGBLED_r = 0.0;
            RGBLED_g = (float) (20 - i) / 10;
            RGBLED_b = 0.0;
        } else if (20 <= i && i < 30) {
            RGBLED_r = (float) (i - 20) / 10;
            RGBLED_g = (float) (i - 20) / 10;
            RGBLED_b = (float) (i - 20) / 10;
        } else if (30 <= i && i < 40) {
            RGBLED_r = (float) (40 - i) / 10;
            RGBLED_g = (float) (40 - i) / 10;
            RGBLED_b = (float) (40 - i) / 10;
        } else {
            i = -1;
        }
        i++;
        Thread::wait(200);    // wait 0.2s
    }
}


void thread2(void const *args)
{
    while (true) {
        SongPlayer mySpeaker(p21);
        mySpeaker.PlaySong(note,duration);
        Thread::wait(6000);    // wait 6s
    }
}


void thread3(void const *args)
{
    while (true) {
        time_t seconds = time(NULL);
        lcd_mutex.lock();
        uLCD.filled_rectangle(0, 0, 127, 63, BLACK);
        char buffer[32];
        strftime(buffer, 32, "%I:%M:%S %p\n", localtime(&seconds));
        uLCD.locate(0,0);
        uLCD.printf(buffer);
        lcd_mutex.unlock();
        Thread::wait(1000);    // wait 1s
    }
}

void thread4(void const *args)
{
    while (true) {
        lcd_mutex.lock();
        uLCD.filled_rectangle(0, 63, 127, 127, BLACK);
        drawairplane(ix, 90);
        lcd_mutex.unlock();
        ix += 1;
        if (ix > 100) {
            ix = 0;
        }
        Thread::wait(500);    // wait 0.75s
    }
}


int main() {
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3
    Thread t4(thread4); //start thread3
    set_time(1256729737);
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        
    }
    Thread::wait(200);    // wait 0.2s
}
