#include "mbed.h"
#include "PinDetect.h"

PwmOut red_led(p23);
PwmOut green_led(p22);
PwmOut blue_led(p21);
PinDetect pbdim(p6);
PinDetect pbbright(p7);
float volatile red_brightness = 0.5f;
float volatile blue_brightness = 0.5f;
float volatile green_brightness = 0.5f;
DigitalIn red_switch(p8);
DigitalIn blue_switch(p9);
DigitalIn green_switch(p10);
void pbdim_hit_callback (void) {
    if (red_switch && (1.0f > red_brightness  || red_brightness >= 0.0f)) {
        red_brightness += 0.1f;
    }
    if (blue_switch && (1.0f > blue_brightness  || blue_brightness >= 0.0f)) {
        blue_brightness += 0.1f;
    }
    if (green_switch && (1.0f > green_brightness  || green_brightness >= 0.0f)) {
        green_brightness += 0.1f;
    }
}
void pbbright_hit_callback (void) {
    if (red_switch && (0.0f < red_brightness || red_brightness <= 1.0f)) {
        red_brightness -= 0.1f;
    }
    if (blue_switch && (0.0f < blue_brightness || blue_brightness <= 1.0f)) {
        blue_brightness -= 0.1f;
    }
    if (green_switch && (0.0f < green_brightness || green_brightness <= 1.0f)) {
        green_brightness -= 0.1f;
    }
}
int main(void) {
    red_switch.mode(PullUp);
    blue_switch.mode(PullUp);
    green_switch.mode(PullUp);
    pbdim.mode(PullUp);
    pbbright.mode(PullUp);
    red_switch.mode(PullUp);
    blue_switch.mode(PullUp);
    green_switch.mode(PullUp);
    wait(0.001);
    
    pbdim.attach_deasserted(&pbdim_hit_callback);
    pbdim.setSampleFrequency();
    pbbright.attach_deasserted(&pbbright_hit_callback);
    pbbright.setSampleFrequency();
    
    while(1) {
        red_led = red_brightness;
        green_led = green_brightness;
        blue_led = blue_brightness;
        wait(.2);
    }
}