#include "mbed.h"
#include "PinDetect.h"

PwmOut led(LED1);
PinDetect pbdim(p7);
PinDetect pbbright(p6);
float volatile brightness = 0.5f;
void pbdim_hit_callback (void) {
    if(1.0f > brightness  || brightness >= 0.0f) {
        brightness+= 0.1f;
    }
}
void pbbright_hit_callback (void) {
    if (0.0f < brightness || brightness <= 1.0f) {
        brightness -= 0.1f;
    }
}
int main() {
    pbdim.mode(PullUp);
    pbbright.mode(PullUp);
    wait(0.001);
    
    pbdim.attach_deasserted(&pbdim_hit_callback);
    pbdim.setSampleFrequency();
    pbbright.attach_deasserted(&pbbright_hit_callback);
    pbbright.setSampleFrequency();
    while(1) {
        led = brightness;
        wait(.2);
    }
}

