#include "mbed.h"

/*DigitalOut led2(LED2);
CAN can2(p30, p29,500000);
int16_t n=0;

int main() {
    printf("main()\n\r");
    CANMessage msg;
    while(1) {
        if(can2.read(msg)) {
            n = ((uint16_t)msg.data[2]<<8) + (uint16_t)msg.data[3];
            //printf("Message received: %x\t%x\t%x\t%x\t%x\t%x\t%x\t%x\t\n\r", msg.data[0],msg.data[1],msg.data[2],msg.data[3],msg.data[4],msg.data[5],msg.data[6],msg.data[7]);    
            printf("Drehzahl: %ld\n\r",n);            
            led2 = !led2;
        } 
        wait(0.2);
    }
}*/

#include "mbed.h"

DigitalOut led2(LED2);
CAN can2(p30, p29,500000);

int main() {
    int16_t n=-1000;
    
    printf("main()\n\r");
    CANMessage msg;
    msg.format=CANExtended;
    msg.id=0x0301;
    msg.len=0x04;
    msg.data[0]=0x00;
    msg.data[1]=0x00;
    msg.data[2]=0x03;
    msg.data[3]=0xD0;
    
    if (n >= 0)
    {
        msg.data[0]=0x00;
        msg.data[1]=0x00;
        msg.data[2]=(int)(n/256);
        msg.data[3]=n%256;
        }
    else
    {
        msg.data[0]=0xFF;
        msg.data[1]=0xFF;
        msg.data[2]=(int)((65536+n)/256);
        msg.data[3]=(65536+n)%256;
        
        
        }
    
    while(1) {
        can2.write(msg);
        //printf("%x %x \n\r",msg.data[2],msg.data[3]);
        wait_ms(20);
        
    }
}
