// -------------------- Motor ---------------------------
#ifdef MOTOR_H
#else
#define MOTOR_H

#include "mbed.h"

#define MOTOR_STEP_TIME_MIN 700
#define MOTOR_STEP_TIME_DEFAULT 5000
#define MOTOR_TICKS_FOR_A_TURN 4096

typedef enum MotorStateList {   // Define Motor States for the State Machine
    Motor_IDLE = 0,
    Motor_RUN,
    Motor_PAUSE,
    Motor_ZERO,
    Motor_CALIB
    } MotorState;
    
typedef enum MotorCommandList { // Define Motor State Machine Commands
    MOTOR_nop = 0,
    MOTOR_start,
    MOTOR_pause,
    MOTOR_restart,
    MOTOR_stop,
    MOTOR_zero
    } MotorCommand;

typedef enum MotorDirectionList { // Define Motor Clockwise or Anticlockwise
    CLOCKWISE = 0,
    COUNTERCLOCKWISE
    } MotorDir;
    
class Motor {
    
    MotorState state;
    MotorCommand command;
    MotorDir direction;

    
    public:
 
    
    Motor(PinName _MPh0, PinName _MPh1, PinName _MPh2, PinName _MPh3, uint32_t TickTime);
    Motor(PinName _MPh0, PinName _MPh1, PinName _MPh2, PinName _MPh3);
    void RunSteps(MotorDir direction, uint32_t steps);
    void RunDegrees(MotorDir direction, float steps);
    void RunInfinite(MotorDir direction);
    void SetDirection(MotorDir dir);
    void TestMotor();
    void RunMotor();
    void setMotorCallback(void (*mIT)());
     void setMotorCallback(void (*mIT)(), bool itOnStop);
 
template<typename T>
void setMotorCallback(T *object, void (T::*member)(void))
{
    _callback = callback(object,member);
    itOnStop = true;
}
 
    void removeMotorCallback();

    uint32_t getCalibration();    
    void setCalibration(uint32_t nbTicksforFullTurn);
    void setDelayBtwTicks(uint32_t tickTime); // in ms
    void setSpeed(float sForOneTurn) ;// nb of s to get rotation of 360° (if 20s, the motor will do 360° in 20 s). 
    
    void Start();
    void Stop();
    void Pause();
    void Restart();
    void SetZero();
    
    MotorStateList getState();
    
    private:
    void initialization(PinName _MPh0, PinName _MPh1, PinName _MPh2, PinName _MPh3, uint32_t TickTime);
 
    void StopMotor();
    void StartMotor();
    void SetCommand(MotorCommand cmd);
    void LeftMotor();
    void RightMotor();
    void ProcessMotorStateMachine();
    Timer tuneTimings;
uint32_t last;
    DigitalOut *MPh0, *MPh1, *MPh2, *MPh3;
    
    int MotorIndex;    // --- Motor Variable
   
    bool init;
    Ticker  MotorSystemTick;    // System Callback for Motor
    timestamp_t MotorStepTime;  // Time in µs for one motor step
    uint32_t    MotorFullTurn;  // Number of step for a complete turn
    int32_t    NumSteps;       // Number of Steps = NumWire * MotorFullTurn
    Callback<void()> _callback;

    bool itOnStop;
};

#endif