#include "mbed.h"
#include <stdio.h> 
#include <stdlib.h> 
#include <time.h> 
#include "LED_WS2812.h"
 
Serial pc(USBTX, USBRX); 
DigitalOut myled(LED1);
DigitalIn greenButton(D3,PullUp);
DigitalIn redButton(D4,PullUp);
DigitalIn blueButton(D5,PullUp);
DigitalIn yellowButton(D6, PullUp);
LED_WS2812 led(D9,4);

int buttonArray[32];
int array[32]; // LEDS colors array

int readButton(int turn){
    int currentValueG, currentValueR, currentValueB, currentValueY, status=0;
    int max=400;
    for (int i=0;i<32;i++){
        buttonArray[i]=55;
    }
    printf("readButton\n");
    for (int i=0; i<= turn; i++){
        for (int t=0; t<max; t++){
            currentValueG = greenButton.read();
            currentValueR = redButton.read();
            currentValueB = blueButton.read();
            currentValueY = yellowButton.read();
            if (currentValueG == 0){
                printf("Green button\n");
                wait_ms(250);
                buttonArray[i]=0;
                t=max;
                status=0;
            }
            else if (currentValueR == 0){
                printf("RedButton\n");
                wait_ms(250);
                buttonArray[i]=1;
                t=max;
                status=0;
            }
            else if(currentValueB == 0){
                printf("BlueButton\n");
                wait_ms(250);
                buttonArray[i]=2;
                t=max;
                status=0;
            }
            else if(currentValueY == 0){
                printf("Yellow button\n");
                wait_ms(250);
                buttonArray[i]=3;
                t=max;
                status=0;
            }
            else if(t>=(max-1)){
                printf("time out !!! \n");
                status=1;
            }
            wait_ms(10);
        }       
    }

    for(int j=0; j<=turn; j++) {
        printf("buttonArray[%d]=%d\n", j, buttonArray[j]);
    }
    printf("end of readButton \n");
    return status;
}

int main() {
    int maxTurn=5, status, diff=0;
    srand(time(0));
    led.SetColor(BLACK);   
    led.SetIntensity(25);
    for(int t=0; t<=maxTurn; t++){
        // generate the array  and ON the LEDs
        printf("turn = %d\n", t);
        array[t]=rand()%4;
        for (int i=0; i<=t; i++){
            switch(array[i])
            {
                case 0:
                    printf(" >>>>>>> green\n");
                    led.SetColor(GREEN,0);
                    wait_ms(500);
                    led.SetColor(BLACK);
                    wait_ms(50);
                    break;
                case 1:
                    printf(" >>>>>>> red\n");
                    led.SetColor(RED,1);
                    wait_ms(500);
                    led.SetColor(BLACK);
                    wait_ms(50);
                    break;
                case 2:
                    printf(" >>>>>>> blue\n");
                    led.SetColor(BLUE,2);
                    wait_ms(500);
                    led.SetColor(BLACK);
                    wait_ms(50);
                    break;
                case 3:
                    printf(" >>>>>>> yellow\n");
                    led.SetColor(YELLOW,3);
                    wait_ms(500);
                    led.SetColor(BLACK);
                    wait_ms(50);
                    break;
                default:
                    printf(" >>>>>>> no color \n");
                    break;
            }
        }
        status = readButton(t);
        // compare two arrays
        if (status==1){
            printf("Time out, game over !\n");
            led.SetColor(ORANGE);
            t=maxTurn;// force t to maxTurn to exit       
        }
        else {
            for(int j=0; j<=t; j++){
                if(array[j]!=buttonArray[j]){
                    j=t;
                    diff=1;
                }
         
            }
            if (diff==1){
                t=maxTurn;
                printf("Color no match, Game Over !\n");
                led.InsertColor(RED);
                led.StartBlink(0.2);
            }
            else{
                if(t<maxTurn){
                    printf("t=%d\n",t);
                    printf("next level !!!\n");
                }
                else{
                    printf("t=%d\n",t);
                    printf("You win !\n");
                    led.InsertColor(GREEN);
                    led.StartBlink(0.2);
                    wait(3);
                    led.StopBlink();
                }
            }
        }
        printf("Turn finished\n");
    }
          
}
