/**
 * Kommunikationsweg zum NFC-Leser im Handyhalter.
 * Kennt alle UID der zugelassenen Benutzer.
 */

#ifndef NFC_H
#define NFC_H

#include "mbed.h"
#include "rtos.h"

class NFC{
private:
    /**
     * Findet heraus, ob die angeführte UID in der Liste ist.
     * @return true := UID ist in der Liste; false := UID ist nicht in der Liste.
     */
    static bool compareUIDs(uint64_t UID);

public:
    /**
     * Überprüft, ob eine RFID vorhanden ist und ob sie auf der Whitelist ist.
     * @return true := Eine RFID ist vorhanden und entspricht einer auf der Whitelist; false := sonst.
     */
    static bool getAccess();

    /**
     * Fügt die UID eines Users zur Whitelist hinzu.
     * @param UID: UID des neuen Users
     * @return true := Ein Fehler ist aufgtreten; false := der User wurde erfolgrech hinzugefügt
     */
    static bool addUser(uint64_t UID);
};

#endif //NFC_H

