#include "LED_Ring.h"

LED_Ring::LED_Ring(): redLED(PC_9), greenLED(PB_8){

    //this->redLED = new PmwOut(PC_9);
    //this->greenLED = new PwmOut(PB_8);

    redLED.period_ms(1);
    greenLED.period_ms(1);

    ledState = off;

    //thread.start(callback(this, &LED_Ring::run));
    this->ticker.attach(callback(this, &LED_Ring::run), 0.001f);
}

/**
 * TODO: run() ist jetzt mit Ticker Realisiert. Statt warten kann jetzt jeder Prozess einmal gemacht werden. => Tickerfrequenz = wait^-1.
 */

void LED_Ring::run(){
    static uint16_t blink = 0;
    static bool orange = false;

    //while( true ){
        switch( ledState ){
            case off:
                redLED.write(0.0f);
                greenLED.write(0.0f);
                Thread::wait(1);
                break;
    
            case shine_red:
                redLED.write(1.0f);
                greenLED.write(0.0f);
                Thread::wait(1);
                break;
    
            case shine_green:
                redLED.write(0.0f);
                greenLED.write(1.0f);
                Thread::wait(1);
                break;
    
            /*case shine_orange:
                redLED.write(1.0f);
                greenLED.write(0.0f);
                Thread::wait(1);
                redLED.write(0.0f);
                greenLED.write(0.8f);
                break;*/
    
            case blink_red:
                if( blink <= 500 ){
                    redLED.write(1.0f);
                    greenLED.write(0.0f);
                    Thread::wait(1);
                } else {
                    redLED.write(0.0f);
                    greenLED.write(0.0f);
                    Thread::wait(1);
                }
                break;
    
            case blink_green:
                if( blink <= 500 ){
                    redLED.write(0.0f);
                    greenLED.write(1.0f);
                    Thread::wait(1);
                } else {
                    redLED.write(0.0f);
                    greenLED.write(0.0f);
                    Thread::wait(1);
                }
                break;
                
            case blink_red_green:
                if( blink <= 500 ){
                    redLED.write(0.0f);
                    greenLED.write(1.0f);
                    Thread::wait(1);
                } else {
                    redLED.write(1.0f);
                    greenLED.write(0.0f);
                    Thread::wait(1);
                }
                break;
    
            /*case blink_orange:
                if( blink <= 500 ){
                    if( orange ){
                        redLED.write(0.6f);
                        greenLED.write(0.0f);
                        Thread::wait(1);
                        redLED.write(0.0f);
                        greenLED.write(0.8f);
                    }
                } else {
                    redLED.write(0.0f);
                    greenLED.write(0.0f);
                    Thread::wait(1);
                }
                break;*/
        }
        blink++;
        if( blink >= 1000) blink = 0;
        orange = !orange;
        Thread::wait(1);
    //}
}
void LED_Ring::shineRed(){
    ledState = shine_red;
}
void LED_Ring::shineGreen(){
    ledState = shine_green;
}
void LED_Ring::shineOrange(){
    ledState = shine_orange;
}
void LED_Ring::blinkRed(){
    ledState = blink_red;
}
void LED_Ring::blinkGreen(){
    ledState = blink_green;
}
void LED_Ring::blinkOrange(){
    ledState = blink_orange;
}
void LED_Ring::blinkRedGreen(){
    ledState = blink_red_green;
}
void LED_Ring::turnOfLED(){
    ledState = off;
}

/*void LED_Ring::operator=(string cmd){
    if( "off" == cmd ) turnOfLED();
    else if( "shine red" == cmd )       shineRed();
    else if( "shine green" == cmd )     shineGreen();
    else if( "shine orange" == cmd )    shineOrange();
    else if( "blink red" == cmd )       blinkRed();
    else if( "blink green" == cmd )     blinkGreen();
    else if( "blink orange" == cmd )    blinkOrange();
}*/