/**
 * Gibt für den Handgriffbetätiger einen Wert zwischen 0x0000 und 0xFFFF zurück.
 */

#ifndef HANDGRIFFBETAETIGUNG_H
#define HANDGRIFFBETAETIGUNG_H

#include "mbed.h"
#include "rtos.h"

#define POTIPIN PC_0

class Handgriffbetaetigung{
private:
    //AnalogIn-Objekt mit dem Pin des Potis
    AnalogIn poti;

    //Hoechster Wert, der der Poti zurückgibt
    static const uint16_t OBERGRENZE = 70;

    //Tiefster Wert, der der Poti zurückgibt
    static const uint16_t UNTERGRENZE = 30;

    //Pin auf dem die Handgriffbetätigung ist
    static const PinName POTIPIN = PC_0;

    //Wenn der Poti den Wert 0 misst, ist er kaputt.
    bool Error;

public:
    /**
     * Konstruiert eine Handgriffbetätigung, der den Potiwert zurückgibt.
     * @param aIn: AnalogIn-Objekt mit dem Pin des Potis.
     */
    Handgriffbetaetigung();

    /**
     * Gibt den Analogwert zurück.
     * @return Analogwert in Prozent
     */
    uint16_t getValue();

    /**
     * Ruft die Funktion getValue() auf
     * @return Analogwert in Prozent
     */
    operator int();
};

#endif
