

#ifndef ENCODER_H_
#define ENCODER_H_

#include <cstdlib>
#include "mbed.h" 


/**
 * This class implements a driver to read the quadrature
 * encoder counter of the STM32 microcontroller.
 */
   
  
class Encoder {
    
    public:
        
                        Encoder(PinName& hallsensor);
        virtual         ~Encoder();
        uint8_t         reset();                // Reset pulse count to 49000, return 0 when not resetted or 1 when resetted
        uint32_t        read();                 // Return Pulses 196000 pulses per Rotation(Pedals)
        float           readAngle();            // Return Angle in Radiants 
        float           readFrequency();         // Return Drehzahl der pedale in rad/s
        float           readAcceleration();     // Return Acceleration of pedale in rad/s^2
        float           readRPM();              // Return Drehzahl in RPM 
        void            ResetInterrupt();      
        operator short();
        
        
    private:
        
        TIM_TypeDef*        TIM;
        InterruptIn         HallSensor;
        PinName             hallsensor;
        Ticker              ticker;
        void                calculateFrequency(); // Fucntion, which calculate the frequency every 5ms
        
        const static float  PI = 3.141592654;
        const static float  dt = 0.005; // 5ms 
        uint8_t             resetOn;
        float               frequency;
        float               acceleration;
        
};

#endif /* ENCODER_COUNTER_H_ */
