/**
 * Gibt für den Daumenbetätiger einen Wert zwischen 0x0000 und 0xFFFF zurück.
 */

#ifndef DAUMENBETAETIGUNG_H
#define DAUMENBETAETIGUNG_H

#include "mbed.h"
#include "rtos.h"

//#define POTIPIN PB_1

class Daumenbetaetigung{
private:
    //AnalogIn-Objekt mit dem Pin des Potis
    AnalogIn poti;

    //Hoechster Wert, der der Poti zurückgibt
    static const uint16_t OBERGRENZE = 75;

    //Tiefster Wert, der der Poti zurückgibt
    static const uint16_t UNTERGRENZE = 31;

    //Pin auf dem die Daumenbetätigung ist
    static const PinName POTIPIN = PC_3;

    //Wenn der Poti den Wert 0 misst, ist er kaputt.
    bool Error;

public:
    /**
     * Konstruiert eine Handgriffbetätigung, der den Potiwert zurückgibt.
     * @param aIn: AnalogIn-Objekt mit dem Pin des Potis.
     */
    Daumenbetaetigung();

    /**
     * Gibt den Analogwert zurück.
     * @return Analogwert von 0x0000 bis 0xFFFF
     */
    uint16_t getValue();

    /**
     * Ruft die Funktion getValue() auf
     * @return Analogwert von 0x0000 bis 0xFFFF
     */
    operator int();
};

#endif
