
/* mbed specific header files. */
#include "mbed.h"

/* Component specific header files. */
#include "stspin240_250_class.h"

/* Variables -----------------------------------------------------------------*/

/* Initialization parameters of the motor connected to the expansion board. */
Stspin240_250_Init_t initDeviceParameters = {
    20000, /* Frequency of PWM of Input Bridge A in Hz up to 100000Hz             */
    20000, /* Frequency of PWM of Input Bridge B in Hz up to 100000Hz             */
    20000, /* Frequency of PWM used for Ref pin in Hz up to 100000Hz              */
    50,    /* Duty cycle of PWM used for Ref pin (from 0 to 100)                  */
    TRUE   /* Dual Bridge configuration  (FALSE for mono, TRUE for dual brush dc) */
};

/* Motor Control Component. */
STSPIN240_250 *motor;


/* Main ----------------------------------------------------------------------*/

int main()
{

    uint8_t demoStep = 0;
   // riv
    /* Initializing Motor Control Component. */
    motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A0 );           //Chiamo i l costruttore per inizializzare l'oggetto motor

    /* Set dual bridge enabled as two motors are used*/
    motor->SetDualFullBridgeConfig(1);

    /* Set PWM Frequency of Ref to 15000 Hz */
    motor->SetRefPwmFreq(0, 15000);       //frequenza clock

    /* Set PWM duty cycle of Ref to 60% */
    motor->SetRefPwmDc(0, 60);

    /* Set PWM Frequency of bridge A inputs to 10000 Hz */
    motor->SetBridgeInputPwmFreq(0,10000);

    /* Set PWM Frequency of bridge B inputs to 10000 Hz */
    motor->SetBridgeInputPwmFreq(1,10000);

    
    
               //INIZIALIZZAZIONI, s1 e s2 conterranno i valori di velocità da dare ai singoli motori
      
                int s0=50;
                int s1=50;
                
                //Definisco due oggetti della classe AnalogIn che chiamo ten1 e ten2, chiamo il costruttore per inizializzarli 
                AnalogIn ten0(A1);  //indico che vorrò leggere la tensione analogica su questi due pin, 
                AnalogIn ten1(A2);  //è la stessa di quella che ho sulle due ruote
                    
                /**** SETTO I DUE MOTORI ALLA STESSA VELOCITA, 50%, E ALLA STESSA DIREZIONE ****/
                
                motor->SetSpeed(0,s0);                          //SETTO LA VELOCITà DEL MOTORE 0 AL 50%
                motor->SetSpeed(1,s1);                          //RIDUCO LA VELOCITA DEL MOTORE 0
                motor->Run(1, BDCMotor::FWD);                   //FACCIO ANDARE AVANTI IL MOTORE 1, per farlo andare indietro basta mettere BWD invece di FWD
                motor->Run(0, BDCMotor::FWD);                   //MOTORE 0 IN AVANTI
                
                
                 while (1)
                 {   
                
                    if(ten1.read() - ten0.read() >0.1)   //la tensione sul motore 0 è 10 volte quella dell'altro motore
                    {
                        s1+=10;
                        motor->SetSpeed(1,s1);      //aumento la velocità del 5%                         
                       // motor->Run(1, BDCMotor::FWD);     
                       
                       printf(" Velocita S1 %6ld\n", s1);
                    }
                    
                    else if (ten0.read() - ten1.read() >0.1)   //la tensione sul motore 0 è 10 volte quella dell'altro motore
                    {
                        
                        s0 +=10;
                        motor->SetSpeed(0,s0);      //aumento la velocità del 5%                         
                       // motor->Run(0, BDCMotor::FWD);     
                       
                       printf(" Velocita S0 %6ld\n", s0);
                                      
                           
                       
                    
                    }
                    
                    wait_ms(250);  // 250 ms
                }
            
            
}
