
/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Component specific header files. */
#include "stspin240_250_class.h"

/* Variables -----------------------------------------------------------------*/

/* Initialization parameters of the motor connected to the expansion board. */
 Stspin240_250_Init_t initDeviceParameters =
 {
  20000, /* Frequency of PWM of Input Bridge A in Hz up to 100000Hz             */
  20000, /* Frequency of PWM of Input Bridge B in Hz up to 100000Hz             */
  20000, /* Frequency of PWM used for Ref pin in Hz up to 100000Hz              */
  50,    /* Duty cycle of PWM used for Ref pin (from 0 to 100)                  */
  TRUE   /* Dual Bridge configuration  (FALSE for mono, TRUE for dual brush dc) */
 };

/* Motor Control Component. */
STSPIN240_250 *motor;

/* Functions -----------------------------------------------------------------*/

/**
 * @brief  This is an example of error handler.
 * @param[in] error Number of the error
 * @retval None
 * @note   If needed, implement it, and then attach it:
 *           + motor->AttachErrorHandler(&myErrorHandler);
 */
void myErrorHandler(uint16_t error)
{
  /* Printing to the console. */
  printf("Error %d detected\r\n\n", error);
  
  /* Infinite loop */
  while(1)
  {
  }    
}

/**
 * @brief  This is an example of user handler for the flag interrupt.
 * @param  None
 * @retval None
 * @note   If needed, implement it, and then attach and enable it:
 *           + motor->AttachFlagIRQ(&myFlagIRQHandler);
 *           + motor->EnableFlagIRQ();
 *         To disable it:
 *           + motor->DisbleFlagIRQ();
 */
void myFlagIRQHandler(void)
{
   /* Code to be customised */
  /************************/

  printf("    WARNING: \"FLAG\" interrupt triggered.\r\n");

  /* Get the state of bridge A */
  uint16_t bridgeState  = motor->GetBridgeStatus(0);
  
  if (bridgeState == 0) 
  {
    if (motor->GetDeviceState(0) != INACTIVE)
    {
      /* Bridges were disabled due to overcurrent or over temperature */
      /* When  motor was running */
        myErrorHandler(0XBAD0);
    }
  }
}
void go (float speed,bool direction);
void turn(bool direction);
void stop();

/* Main ----------------------------------------------------------------------*/

int main()
{
  
  /* Printing to the console. */
  printf("STARTING MAIN PROGRAM\r\n");
    
//----- Initialization 

  motor = new STSPIN240_250(D2, D9, D6, D7, D5, D4, A0);
 
  if (motor->Init(&initDeviceParameters) != COMPONENT_OK) exit(EXIT_FAILURE);

  /* Set dual bridge enabled as two motors are used*/
  motor->SetDualFullBridgeConfig(1);

  /* Attaching and enabling an interrupt handler. */
  motor->AttachFlagIRQ(&myFlagIRQHandler);
  motor->EnableFlagIRQ();
    
  /* Attaching an error handler */
  motor->AttachErrorHandler(&myErrorHandler);

  /* Printing to the console. */
  printf("Motor Control Application Example for 2 brush DC motors\r\n");

  /* Set PWM Frequency of Ref to 15000 Hz */ 
  motor->SetRefPwmFreq(0, 15000); 

  /* Set PWM duty cycle of Ref to 60% */ 
  motor->SetRefPwmDc(0, 60);
  
  /* Set PWM Frequency of bridge A inputs to 10000 Hz */ 
  motor->SetBridgeInputPwmFreq(0,10); 
  
  /* Set PWM Frequency of bridge B inputs to 10000 Hz */ 
  motor->SetBridgeInputPwmFreq(1,10000); 
  
  /* Infinite Loop. */
  printf("--> Infinite Loop...\r\n");
  
  
  while (1)
  {
    go(100,1);

    
    
  }
}
 
void go (float speed,bool direction){
    /* direction 1 forward, 0 back*/
    motor->SetSpeed(0,speed);
    motor->SetSpeed(1,speed);
    
    if (direction){
        motor->Run(0,BDCMotor::FWD);
        motor->Run(1,BDCMotor::FWD);
        }
    else{
        motor->Run(0,BDCMotor::BWD);
        motor->Run(1,BDCMotor::BWD);
        }
}

void stop(){
    motor->SetSpeed(0,0);
    motor->SetSpeed(1,0);
    }
    
void turn(bool direction){
    /*dir 1 left - 0 right */
    if (direction){
        motor->SetSpeed(0,20);
        motor->SetSpeed(1,70);
        
        motor->Run(0,BDCMotor::FWD);
        motor->Run(1,BDCMotor::FWD);
        
        wait_ms(1100);
        }
    else {
        motor->SetSpeed(1,20);
        motor->SetSpeed(0,70);
        
        motor->Run(0,BDCMotor::FWD);
        motor->Run(1,BDCMotor::FWD);
        
        wait_ms(1100);
            }
    }
