/*
    Conversione dei dati grezzi del giroscopio su scheda IKS01A1 in gradi
*/

/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a1.h"

#define  sens 70


/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();


/* Simple main function */
int main() {
  uint8_t id;
  int32_t axes[3];
  int32_t off[3];
  float parziale[3] = {0,0,0};   //inizializzazione vettore senza ciclo FOR
  float finale[3] = {0,0,0};
  int32_t k=0;
  
  printf("\r\n--- Starting new run ---\r\n");
  gyroscope->ReadID(&id);
  printf("LSM6DS0 accelerometer & gyroscope = 0x%X\r\n", id);
  
  wait(1.5);
  
  //acquisizione offset
  accelerometer->Get_X_Axes(off);
  printf("off [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", off[0], off[1], off[2]);

 
  while(1) {
    printf("\r\n");

    accelerometer->Get_X_Axes(axes);
    printf("LSM6DS0 [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    gyroscope->Get_G_Axes(axes);
    printf("LSM6DS0 RAW [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    for(int i=0;i<3;i++)
        axes[i]=axes[i]-off[i];
        
    printf("LSM6DS0 FINE [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    
        
    k=k+1;
    wait_ms(1);  //dt

    // Ricavo il parziale della velocità angolare
    for(int i=0;i<3;i++)
    {
        parziale[i]=(axes[i]*sens)/1000;// passo da mdps a dpLSB
        
        finale[i]=(finale[i]-19)/2.84;// levo la correzione per poter sommare i dati parziali
    
        parziale[i]/= 1000;// moltiplico per il dt (1ms)
   
        if (axes[i]>150 ||axes[i]<-150)
            finale[i] += parziale[i];     // integro 
    
        finale[i]=(finale[i]*2.84)+19;// correggo offset e guadagno che ho ricavato da una "taratura" grezza (ricavo la retta )
        
    }
    printf("finale  [gyro/d]:   %6f, %6f, %6f\r\n", finale[0], finale[1], finale[2]);//angolo

  }

}
