
/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a2.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A2 *mems_expansion_board = X_NUCLEO_IKS01A2::Instance(D14, D15, D4, D5);


#define  sens 70 // sensibilità presa dal datasheet per il fondo scala utilizzato 

static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;
Timer t;

/* Simple main function */
int main() {
  uint8_t id;
  int32_t mdps[3];
  int32_t acc[3];
  int32_t off[3];
  float parziale[3];
  float angolo[3];
  float dt=0;
  
  for(int i=0;i<3;i++)
{parziale[i]=0;}

 for(int i=0;i<3;i++)
{angolo [i]=0;}
  /* Enable all sensors */
 
  acc_gyro->Enable_X();
  acc_gyro->Enable_G();
  
  printf("\r\n--- Starting new run ---\r\n");
  acc_gyro->ReadID(&id);
  printf("LSM6DSL accelerometer & gyroscope = 0x%X\r\n", id);
  // attendo l' inzializzazione
  wait(1.5);    
  
  // effettuo una prima acquisizione del giroscopio per ottenere l'offset delle velocità angolari
 acc_gyro->Get_G_Axes(mdps);   
 printf("LSM6DSL [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", mdps[0], mdps[1], mdps[2]);
 
 for(int i=0;i<3;i++){ 
off[i]=mdps[i];}

  printf("off [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", off[0], off[1], off[2]);
  
  while(1) {
    
    printf("\r\n");

    acc_gyro->Get_X_Axes(acc);
  
    printf("LSM6DSL [acc/mg]:      %6ld, %6ld, %6ld\r\n", acc[0], acc[1], acc[2]);
    
 t.stop();
   dt= t.read();
       //printf("The time taken was %d milliseconds\n", t.read_ms());
        
        
    acc_gyro->Get_G_Axes(mdps);
    
    t.reset();
    t.start();
    
    printf("LSM6DSLrow [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", mdps[0], mdps[1], mdps[2]);
    
    // sottraggo l'offset
for(int i=0;i<3;i++)
{mdps[i]=mdps[i]-off[i];}
       printf("LSM6DSLfine [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", mdps[0], mdps[1], mdps[2]);

    //wait_ms(1);
    
    
    // ricavo il parziale dalla velocità angolare
    
    for(int i=0;i<3;i++)
{
// passo da mdps a dpLSB

    parziale[i]=(mdps[i]*sens)/1000;
    
// levo la correzione per poter sommare i dati parziali off 19 coeff 2.84
angolo[i]=(angolo[i]-(-3.19211))/0.0140888;
// moltiplico per il dt 
    parziale[i]*=(dt);
    
   if (mdps[i]>140 ||mdps[i]<-140)// ci si puo mettere anche 70 come soglia non cambia molto
    angolo[i] += parziale[i];     // integro 
    
// correggo offset e guadagno che ho ricavato da una "taratura" (ricavo la best fit line  )
  
   angolo[i]=(angolo[i]*0.0140888)+(-3.19211);
}


    printf("angolo  [gyro/d]:   %6f, %6f, %6f\r\n", angolo[0], angolo[1], angolo[2]);//angolo
  }
}
