
/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a2.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A2 *mems_expansion_board = X_NUCLEO_IKS01A2::Instance(D14, D15, D4, D5);


#define  sens 70

static LSM6DSLSensor *acc_gyro = mems_expansion_board->acc_gyro;


/* Simple main function */
int main() {
  uint8_t id;
  int32_t axes[3];
  int32_t off[3];
  float parziale[3];
  float finale[3];
  int32_t k=0;
  for(int i=0;i<3;i++)
{parziale[i]=0;}

 for(int i=0;i<3;i++)
{finale [i]=0;}
  /* Enable all sensors */
 
  acc_gyro->Enable_X();
  acc_gyro->Enable_G();
  
  printf("\r\n--- Starting new run ---\r\n");
  acc_gyro->ReadID(&id);
  printf("LSM6DSL accelerometer & gyroscope = 0x%X\r\n", id);
  wait(1.5);
 acc_gyro->Get_G_Axes(axes);
 printf("LSM6DSL [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
 for(int i=0;i<3;i++){
off[i]=axes[i];}
  printf("off [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", off[0], off[1], off[2]);
  while(1) {
    printf("\r\n");

    acc_gyro->Get_X_Axes(axes);
    printf("LSM6DSL [acc/mg]:      %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);

    acc_gyro->Get_G_Axes(axes);
    printf("LSM6DSLrow [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
for(int i=0;i<3;i++)
{axes[i]=axes[i]-off[i];}
       printf("LSM6DSLfine [gyro/mdps]:   %6ld, %6ld, %6ld\r\n", axes[0], axes[1], axes[2]);
    k=k+1;
    wait_m(1);
    
    // ricavo l'parziale dalla velocità angolare
    
    for(int i=0;i<3;i++)
{
    parziale[i]=(axes[i]*sens)/1000;


    parziale[i]/= 1000;
   if (axes[i]>150 ||axes[i]<-150)
    finale[i] += parziale[i];
  
}
    printf("finale  [gyro/d]:   %6f, %6f, %6f\r\n", finale[0], finale[1], finale[2]);//angolo
  }
}
