#include <mbed.h>
Serial pc(USBTX, USBRX,921600);
#define kHz 1000
#define MHz 1000000
#define PFD 19.68
LocalFileSystem local("local");

#pragma diag_suppress 870


void calsat_callback(char c);
void calsat_callback(char c){
    pc.printf("%02hhx ",c);
}



class calsat32
{
public:
    int Fractional_N;
    int Integer_N;
    int intbin[8];
    int decbin[15];
    int register_data;//レジスタへ入れるファイルから読み込んだ10進数の値
    int length; //値の長さ
    int size;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
    int register_num;//レジスタ番号
    int buf;
    char command[128];

    const char* filename;
    FILE *fp;

    calsat32()
    {
        Fractional_N = 0;
        Integer_N = 0;
        register_data = 0;//レジスタへ入れる1ファイルから読み込んだ10進数の値
        length = 0; //値の長さ
        size = 0;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
        register_num = 1;//レジスタ番号
        filename = "/local/register_set_1.txt";
    }
    //main関数内でコマンドが0x00の時にmainでbinary()を呼ぶと計算をしてuint_32型の値を返す

    void Shift_bit(uint32_t& Register, int Register_data, int Size)
    {
        Register |= (Register_data << Size);
    }

    void file_read(char* command)
    {
        /* ファイルのオープン */
        char name[100] = {};//出力はしない
        if ((fp = fopen("/local/register.txt", "r")) == NULL) {
            fprintf(stderr, "%sのオープンに失敗しました.\r\n", filename);
            exit(EXIT_FAILURE);
        }

        /* ファイルの終端まで文字を読み取り表示する */
        int num[5] = {1,3,0,5,4};
        int l = 1;//行数
        uint32_t _register = 0;//最終的に欲しいレジスタの値.32ビット
        while ( fscanf(fp,"%[^,],%d,%d%d",name, &register_data,&length,&buf) != EOF ) {
            if(l == 1 || l == 14 || l == 21 || l == 26 || l == 36)
                l++;

            else {
                printf("%d %d \r\n",register_data, length );

                //レジスタ０にcalsatから受け取った値を格納するとき
                if(register_num == 3 && size == 4 ) {
                    Shift_bit(_register, binary(command), 4);
                    size = 27;
                }

                //テキストファイルから受け取った値を格納するとき
                Shift_bit(_register, register_data, size);
                size += length;
                if(register_num == 1 && size == 26) {
                    printf(" = reg_%d ",num[register_num - 1]);
                    show(_register);
                    register_num++;
                    _register = 0;
                    size = 0;
                }
                if(size == 32) {
                    //これで一つ完成.この値をどういう風にやるかは未定show()みたいなのを作るか？
                    printf(" = reg_%d ",num[register_num - 1]);
                    show(_register);
                    register_num++;
                    _register = 0;
                    size = 0;

                }
                //printf("%s %d %d\n",name,register_data,length);
                l++;
            }
        }
        /* ファイルのクローズ */
        fclose(fp);
    }

    uint32_t binary(char* command)
    {
        double  RFout = doppler(command);
        double n = RFout * 2 / PFD;
        Integer_N = (int)n;
        double test = (n - (int)n);
        Fractional_N = test*32768;

        uint32_t data = Fractional_N;
        return data |= (Integer_N << 15);//レジスタ入力に適した形にした23桁の2進数を返す
    }
    //データを取得し返す関数
    double doppler(char *a)
    {
        int data[10] = {0};
        double doppler_data = 0;
        int flag = 0;
        for(int i = 5; i < 10; i++) {
            char c = a[i];
            data[flag] = (c >> 4) & 0xf;
            data[flag+1] = c & 0xf;
            flag += 2;
        }

        doppler_data = 10 * data[0] + data[1] + kHz * data[2] + 100 * data[3] + 100*kHz * data[4] + 10*kHz * data[5] + 10*MHz * data[6] + MHz * data[7] + data[8] + 100*MHz * data[9];//Hz
        printf("\n%lf\r\n",doppler_data / 1000000); //Mhz

        return doppler_data / 1000000;
    }

    void packet(char data, int i)
    {
        command[i] = data;
        if(data == 0xfd && command[4] == 0x00) {
            file_read(command);
        }
    }

    void show(uint32_t bin)
    {
        for(int i = 32; i > 0; i--) {
            if(bin & (1 << (i - 1))) {
                pc.printf("1");
            } else {
                pc.printf("0");
            }
        }
        printf("\r\n");
    }

};

int main()
{
    Serial device( p9, p10, 9600);
    
    while(1) {
        if(device.readable()) {
            calsat32 tmp;
            int i = 0;
            char c = device.getc();
            calsat_callback(c);
            tmp.packet(c,i);
            printf("\r\n");
            i++;
            
        }
    }
}
