#include <mbed.h>
Serial pc(USBTX, USBRX,921600);
Serial device( p9, p10, 9600);
#define kHz 1000
#define MHz 1000000
LocalFileSystem local("local");

class calsat32
{
public:
    int Fractional_N;
    int Integer_N;
    int intbin[8];
    int decbin[15];
    int register_data;//レジスタへ入れるファイルから読み込んだ10進数の値
    int length; //値の長さ
    int size;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
    int register_num;//レジスタ番号
    int buf;
    const char* filename;
    FILE *fp;

    calsat32()
    {
        Fractional_N = 0;
        Integer_N = 0;
        register_data = 0;//レジスタへ入れる1ファイルから読み込んだ10進数の値
        length = 0; //値の長さ
        size = 0;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
        register_num = 1;//レジスタ番号
        //filename = "/local/register_set_1.txt";
    }
    //main関数内でコマンドが0x00の時にmainでbinary()を呼ぶと計算をしてuint_32型の値を返す

    void file_read(char* command)
    {
        /* ファイルのオープン */
        char name[100] = {};//出力はしない
        if ((fp = fopen("/local/register.txt", "r")) == NULL) {
            fprintf(stderr, "%sのオープンに失敗しました.\r\n", filename);
            exit(EXIT_FAILURE);
        }
        
        /* ファイルの終端まで文字を読み取り表示する */
        uint32_t _register = 0;//最終的に欲しいレジスタの値.32ビット
        while ( fscanf(fp,"%[^,],%d,%d%d",name, &register_data,&length,&buf) != EOF ) {
            printf("%d %d \r\n",register_data, length );
            size += length;
            void Shift_bit(uint32_t _register, int register_data, int size);
            /*
            if(register_num == 3 && size == 5) {
                binary(command);
                size = 28;
            }
            */
            if(register_num == 1 && size == 26 ) {
                _register |= (_register << 6);
                show(_register);
                exit(1);
            }
            /*
            if(size == 32) {
                 //これで一つ完成.この値をどういう風にやるかは未定show()みたいなのを作るか？
                show(_register);
                size = 0;
                _register = 0;
                register_num++;
            }
            //printf("%s %d %d\n",name,register_data,length);
            */
        }
        /* ファイルのクローズ */
        fclose(fp);
    }
    void Shift_bit(uint32_t& Register, int Register_data, int Size)
    {
        Register |= (Register_data << Size);
    }
    uint32_t binary(char* command)
    {
        double  num = doppler(command);
        double n = num * 2 / 19.68;
        Integer_N = (int)n;
        double test = (n - (int)n);
        Fractional_N = test*32768;

        //小数部分
        for(int i=0; Fractional_N>0; i++) {
            decbin[i] = Fractional_N % 2;
            Fractional_N = Fractional_N / 2;
        }
        int l = 15;
        while( l>0 ) {
            printf(" %d", decbin[--l]);/* 2進数の出力 */
        }
        printf("\r\n");
        uint32_t dec = 0;
        for(int i = 0; i < l; i++ ) {
            dec |= (decbin[i] << i);
        }
        //整数部分
        for(int i = 0; Integer_N > 0; i++) {
            intbin[i] = Integer_N % 2;
            Integer_N = Integer_N / 2;
        }
        int k = 8;
        while( k>0 ) {
            printf(" %d", intbin[--k]);
        }
        printf("\r\n");
        uint32_t inte = 0;
        for(int i = 0; i < k; i++ ) {
            inte |= (intbin[i] << i);
        }

        return dec |= (inte << 8);//レジスタ入力に適した形にした23桁の2進数を返す
    }
    //データを取得し返す関数
    double doppler(char *a)
    {
        int data[10] = {0};
        double doppler_data = 0;
        int flag = 0;
        for(int i = 5; i < 10; i++) {
            char c = a[i];
            data[flag] = (c >> 4) & 0xf;
            data[flag+1] = c & 0xf;
            flag += 2;
        }

        doppler_data = 10 * data[0] + data[1] + kHz * data[2] + 100 * data[3] + 100*kHz * data[4] + 10*kHz * data[5] + 10*MHz * data[6] + MHz * data[7] + data[8] + 100*MHz * data[9];
        printf("\n%lf\r\n",doppler_data / 1000000);

        return doppler_data / 1000000;
    }
    void show(uint32_t bin)
    {
        for(int i = 32; i > 0; i--) {
            if(bin & (1 << (i - 1))) {
                pc.printf("1");
            } else {
                pc.printf("0");
            }
        }
        printf("\r\n");
    }

};

int main()
{   char command[] = {};
    calsat32 a;
    a.file_read(command);
    return 0;
}
