/* --------------------------------------------------------------------------
// update 01/01/2021: remove ethernet calls : ok
//
// update 30/12 update libs
//
// test compile ok 31/07/2020 

// 01/09/2020 : update JPA serial  et CAN : tests OK sur CAN et 1 srial 2
              : attention 1 seul serial operationnel serial 2 - serial 7 ne marche pas en reception
//            : test ok send/receive tasmota sur serial 2
// 30/08/2020 : emission CAN OK en Wifi sur tasmota ou udp bridge
//              mais pb reception caracteres sur port serie ( idem port series pc ouu serial 7

// 02/08/2020
// add sd parameters: read ok
192.168.1.30
0;Ethernet
1;WiFi
1;can
1;serial
F;Fonction
0;Touche1 status : off
0xFF00FF00;Touche1 BackColor
0xFF000000;Touche1 TextColor
Pompe  ; Touche1 text
Piscine ; Touche1 text1
1;Touche2 Status : off
0xFFFF0000; Touche2 BackColor
0xFFFFFFFF; Touche2 TextColor
Eclair ;Touche2 text 
Piscine ;Touche2 text1
0; Touche3 Status : off
0xFF00FF00; Touche3 BackColor
0xFFFFFF00; Touche3 TextColor
Leds Bl ;Touche3 text
Piscine ; Touche3 text1
1; Touche4 Status : off
0xFF800000; Touche4 BackColor
0xFFFFFF00; Touche4 TextColor
Porche ; Touche4 text
entree ; Touche4 text1
Temp Piscine ; Temp1 text
0xFF404040; backColorTemp1
0xFFFFFF00;  txtColorTemp1   
Temp Exterieur ; Temp2 text 
0xFF404040; backColorTemp2
0xFFFFFF00; txtColorTemp2

// works ok 31/07/2020
// updated package from jpa
// added fonts in  bsp_disco_f746ng/utilities/fonts
// fonts.h updated to manage added fonts
// grovestream.cpp & grovesttream.h updated
// remove stm32746ng_dicovery_sd in /bsp_disco_f746ng/drivers/stm32746ng_discovery
// mainSDAcardJPA issue: add sdcardjpa.cpp in lib /sdfilesystem_warning_fixed
// isue with big fonts: replace /bsp_disco_f746ng/drivers/stm32746ng-discovery/stm32746ng-discovery_lcd.c &.h

// need to add CAN and WiFi

 STM32F746 GroveStreams Stream Feed via Ethernet
 This GroveStreams example is designed for the STM32F746.
 https://www.grovestreams.com/developers/getting_started_stm32F746.html
 The STM32 uses DHCP and DNS for a simpler network setup.
*/

#if !FEATURE_LWIP
#error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "LcdDiscoF746NgTracer.h"
// #include "GroveStreams.h"
#include "MbedJSONValue.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "CANMsg.h"
//#include "ManageBufferJPA.h"
#include "main.h"

extern char textButton[5][8];
extern char text1Button[5][8];
extern char textTempTitle[3][30];
extern uint32_t backColorButton[5], txtColorButton[5];
extern char statusButton[5][30];

//#include "touchScreen.cpp"
int touchInitJPA1();                // from touchScreenJPA.cpp
int touchJPA1();                    // from touchScreenJPA.cpp
int touchInitGuiJPA1();             // from touchScreenJPA.cpp
int sendTouchJPA(int xx);           // from touchScreenJPA.cpp
time_t lastToucheTime = 0;
int touchButtonJPA1(int numButton); // from touchScreenJPa.cpp

//#include "GuiJPA.cpp"
int initDisplayTemp();              
int initDatasGuiJPA();
int setTemp1(std::string temp1);
int setTemp2(std::string temp2);
int sendInitDatasJPA(int xx);
int timer_lcd_on = 0;

//#SDCARD
int mainSDCardJPA(); //in sdcardjpa.cpp in lib /sdfilesystem_warning_fixedd

//GroveStreams Stream IDs. Stream IDs tell GroveStreams which component streams the values will be assigned to.
//Don't change these unless you edit your GroveStreams component definition and change the stream IDs to match these.
const char      gsStreamId1[] = "voltage";
const char      gsStreamId2[] = "temperature";
char            gsStreamIPdatas[] = "192.168.1.49";
int             ethernet_actif = '0';
int             wifi_actif = '1';
int             can_actif = '1';
int             serial_actif = '1';
char            read_sd[] = "";
char function_mod[]= "O";
 
 char touch1_status[]= "0";
 char touch1_back_color[]= "0xFF404040";
 char touch1_text_color[]= "0xFFFFFF00";
 char touch1_text[]= "Touch1";
 char touch1_text1[]= "Text1";

 char touch2_status[]= "0";
 char touch2_back_color[]= "0xFF404040";
 char touch2_text_color[]= "0xFFFFFF00";
 char touch2_text[]= "Touch2";
 char touch2_text1[]= "Text2";

 char touch3_status[]= "0";
 char touch3_back_color[]= "0xFF404040";
 char touch3_text_color[]= "0xFFFFFF00";
 char touch3_text[]= "Touch3";
 char touch3_text1[]= "Text3";

 char touch4_status[]= "0";
 char touch4_back_color[]= "0xFF404040";
 char touch4_text_color[]= "0xFFFFFF00";
 char touch4_text[]= "Touch4";
 char touch4_text1[]= "Text4";

 char temp1_text[]= "Temp1";
 char temp1_back_color[]= "0xFF404040";
 char temp1_text_color[]= "0xFFFFFF00";

 char temp2_text[]= "Temp2";
 char temp2_back_color[]= "0xFF404040";
 char temp2_text_color[]= "0xFFFFFF00";
 


int len_line_sd = 0;

uint8_t         text2[30];
uint8_t         counter = 0;
float           voltage;

Timer           timer;
extern Timer           timer_lcd;
AnalogIn        analogIn(A0);

// CAN ------------------------------------------------------------
CAN             can(PB_8, PB_9);  // CAN Rx pin name, CAN Tx pin name
CANMsg          rxMsg;
CANMsg          txMsg;

// Other Settings
int             updateFrequency = 20;    // Update frequency in seconds. Change this to change your sample frequency.

AnalogIn        adc_temp(ADC_TEMP);
AnalogIn        adc_vref(ADC_VREF);
DigitalOut      myled(LED1);

void initSerial();
void sendSerialUSB(char * str);
void receiveSerialUSB();
void sendSerial2(char * str);
void receiveSerial2();
void sendSerial7(char * str);
void receiveSerial7();

//extern volatile char            bufferSerialUSB[];
extern volatile int             msgSerialUSB;
extern char                     stringSerialUSB[];               // trame from serialUSB
extern int                      stringSerialUSBok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

extern volatile int             msgSerial2;
extern char                     stringSerial2[];               // trame from serialUSB
extern int                      stringSerial2ok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

extern volatile int             msgSerial7;
extern char                     stringSerial7[];               // trame from serialUSB
extern int                      stringSerial7ok;               // si ==1 alors trame dispo (fin de trame == LF ou 10

//extern Serial          serialUSB(USBTX, USBRX);    // serial PC
//extern Serial          serial2(PC_6, PC_7); // TX, RX for udp bridge
//extern Serial          serial7(PF_7, PF_6); // TX, RX for extension

#define BOARD1                  1       // comment out this line when compiling for board #2
    const unsigned int  RX_ID = 0x101;
    const unsigned int  TX_ID = 0x100;


// ---------------------------------------------------------------------------------------
//* @brief   Prints CAN message to PC's serial terminal
void printMsg(CANMessage& msg, int dir)
{   if (dir ==0)
    {  //BSP_LCD_DisplayStringAt(0, LINE(6), (uint8_t *)"Message sent    ", LEFT_MODE); 
         printf(" Can message sent : ");
         printf("ID = 0x%.3X Data=", msg.id);
         for(int i = 0; i < msg.len; i++) printf(" 0x%.2X", msg.data[i]);
        printf("\n");       
    }    
    else
    {   printf(" Can message receive : ");
        /*
        printf("  ID      = 0x%.3X\r\n", msg.id);
        printf("  Type    = %d\r\n", msg.type);
        printf("  Format  = %d\r\n", msg.format);
        printf("  Length  = %d\r\n", msg.len);
        */
        printf("ID = 0x%.3X Data=", msg.id);
        for(int i = 0; i < msg.len; i++) printf(" 0x%.2X", msg.data[i]);
        printf("\n");
    }
}

/** -----------------------------------------------------------------------------------------
 * @brief   Handles received CAN messages
 * @note    Called on 'CAN message received' interrupt.
 */
int CanRcv = 0;
void onCanReceived(void)
{   can.read(rxMsg);
    CanRcv = 1;
}

// ------------------------------------------------------------------------------------------
int main()
{   initSerial();   
   // attach ISR to handle received messages
    timer.start();          // start timer
    timer_lcd.start();      // start timer lcd off
    timer_lcd_on = 1;
    sendSerialUSB("CAN_Hello board serialUSB #1\r\n");   
    sendSerial2("CAN_Hello board serial2 #1\r\n");
    sendSerial7("CAN_Hello board serial7 #1\r\n");
    printf("\nInit SDCard ...\n");
    mainSDCardJPA() ;  // init SD - read  prog parameters from SD (from sdcardjpa.cpp in sdfilesystem_warning_fixed lib
    // reaf following datas
    // IP address, Ethernet actif, Wifi actif, Can actif, serial actif,fonction, buttons parameters
    // store local variables from sd
    // gsStreamIPdatas[];
    // ethernet_actif[] ; wifi_actif[];can_actif[]; serial_actif[]; function_mod[]= "O";   
    // touch1_status[]= "0"; touch1_back_color[]= "0xFF404040"; touch1_text_color[]= "0xFFFFFF00"; touch1_text[]= "Touch1"; touch1_text1[]= "Text1";
    // touch2_status[]= "0"; touch2_back_color[]= "0xFF404040"; touch2_text_color[]= "0xFFFFFF00"; touch2_text[]= "Touch2"; touch2_text1[]= "Text2";
    // touch3_status[]= "0"; touch3_back_color[]= "0xFF404040"; touch3_text_color[]= "0xFFFFFF00"; touch3_text[]= "Touch3"; touch3_text1[]= "Text3";
    // touch4_status[]= "0"; touch4_back_color[]= "0xFF404040"; touch4_text_color[]= "0xFFFFFF00"; touch4_text[]= "Touch4"; touch4_text1[]= "Text4";
    // temp1_text[]= "Temp1"; temp1_back_color[]= "0xFF404040"; temp1_text_color[]= "0xFFFFFF00";
    // temp2_text[]= "Temp2"; temp2_back_color[]= "0xFF404040"; temp2_text_color[]= "0xFFFFFF00";
 
    printf("\nFin init SDCard ...\n");
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE);  // clear LCD
    uint8_t text[300];
    printf("Start Prog\n");    
    std::string temp1;
    std::string temp2;
    
    //lastSuccessfulUploadTime is used for upload frequency.
    time_t lastSuccessfulUploadTime = 0;    
    printf("\n Init touchJPA1 ...\n");
    int yy;
    printf("\n Init initDisplayTemp ...\n"); 
    yy = initDisplayTemp();   // from guijpa.cpp - Init display
    printf("\ninit touchInitJPA1 ...\n");
    yy = touchInitJPA1();  // from touchscreen.cpp - init touchscreen
    yy = touchInitGuiJPA1();  // from touchscreen.cpp - display buttons
    printf("\ninit initDatasGuiJPA ...\n");
    yy = initDatasGuiJPA();  // from guijpa.cpp - config buttons  - ethernet connection          
    ////lcd.printf("Starting...");
    printf("Starting...\n");
    lastToucheTime = time(NULL);
    char data[5];
     
   // config can --------------------------------------
    can.frequency(125000); // set CAN bit rate to 125 kbps
    //can.filter(RX_ID, 0xFFF, CANStandard, 0); // set filter #0 to accept only standard messages with ID == RX_ID
    can.attach(onCanReceived, CAN::RxIrq);   
    
    BSP_LCD_DisplayOff();
    BSP_LCD_DisplayOn();
    //BSP_LCD_SetBackColor(LCD_COLOR_RED);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_RED);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
   
    // main loop ---------------------------------------------------
    while (true) {       
        if (CanRcv > 0)  // message CAN received ---------------------
        {   CanRcv = 0;    
            printMsg(rxMsg,1);  
            BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Can msg rec", CENTER_MODE);
            if (rxMsg.id == RX_ID) 
            {   rxMsg >> counter;
                rxMsg >> voltage;    
                //serialUSB.printf("  counter = %d\r\n", counter);
                //serialUSB.printf("  voltage = %e V\r\n", voltage);
            }
        }
        if (msgSerialUSB > 0) {receiveSerialUSB();}  // serial USB message received ----------------
        if (stringSerialUSBok == 1) {printf("Trame SerialUSB : %s",stringSerialUSB);stringSerialUSBok=0;}
        
        if (msgSerial2 > 0) {receiveSerial2();}  // serial bridge message received -----------------
        if (stringSerial2ok == 1) 
        {   printf("Trame Serial2 : %s",stringSerial2);
            stringSerial2ok=0;
            // decodage json datas
            // trame reçue : {"Temp1":"25","Temp2":"30"}
            char resultBuffer[100]= {0};
            //resultBuffer = stringSerial2;
            //if (strlen(resultBuffer) > 0 && resultBuffer[0] == '{') 
            if (strlen(stringSerial2) > 0 && stringSerial2[0] == '{') 
            {       MbedJSONValue mbedJson;        //parse(mbedJson, resultBuffer); 
                    parse(mbedJson, stringSerial2);                   
                    sprintf((char*)text, "HTTP string : %s\n", stringSerial2);                
                    if (mbedJson.hasMember("Temp1")) 
                    {   printf("Serial2 temp1: %s",stringSerial2);
                        int pp = setTemp1(mbedJson["Temp1"].get<std::string>());  // display temp1 on lcd                     
                    }
                    if (mbedJson.hasMember("Temp2")) 
                    {   int tt=setTemp2(mbedJson["Temp2"].get<std::string>());                      
                    }
                    // add buttons parameters 
                    // decode button trame
                    if (mbedJson.hasMember("Touche4")) 
                    {   printf("Touche 4 update status received");
                        string s; 
                        s = mbedJson["Touche4"]["Status"].get<std::string>();
                        sprintf(statusButton[4],s.c_str());
                        printf(s.c_str());
                        printf("\n");   
                        if (s=="on")
                        {   txtColorButton[4] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                            backColorButton[4] = (uint32_t)strtoul("0xFF000000", NULL,16);
                        }
                        else
                        {   txtColorButton[4] = (uint32_t)strtoul("0xFF000000", NULL,16);
                            backColorButton[4] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                        }    
                        touchButtonJPA1(4);                                                                  
                    }
                    if (mbedJson.hasMember("Touche1")) 
                    {   printf("Touche 1 update status received");
                        string s; 
                        s = mbedJson["Touche1"]["Status"].get<std::string>();
                        sprintf(statusButton[1],s.c_str());
                        printf(s.c_str());
                        printf("\n");   
                        if (s=="on")
                        {   txtColorButton[1] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                            backColorButton[1] = (uint32_t)strtoul("0xFF000000", NULL,16);
                        }
                        else
                        {   txtColorButton[1] = (uint32_t)strtoul("0xFF000000", NULL,16);
                            backColorButton[1] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                        }    
                        touchButtonJPA1(1);                                                                  
                    }
                    if (mbedJson.hasMember("Touche2")) 
                    {    printf("Touche 2 update status received");
                        string s; 
                        s = mbedJson["Touche2"]["Status"].get<std::string>();
                        sprintf(statusButton[2],s.c_str());
                        printf(s.c_str());
                        printf("\n");   
                        if (s=="on")
                        {   txtColorButton[2] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                            backColorButton[2] = (uint32_t)strtoul("0xFF000000", NULL,16);
                        }
                        else
                        {   txtColorButton[2] = (uint32_t)strtoul("0xFF000000", NULL,16);
                            backColorButton[2] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                        }    
                        touchButtonJPA1(2);                                                                  
                    }
                    if (mbedJson.hasMember("Touche3")) 
                    {   printf("Touche 3 update status received");
                        string s; 
                        s = mbedJson["Touche3"]["Status"].get<std::string>();
                        sprintf(statusButton[3],s.c_str());
                        printf(s.c_str());
                        printf("\n");   
                        if (s=="on")
                        {   txtColorButton[3] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                            backColorButton[3] = (uint32_t)strtoul("0xFF000000", NULL,16);
                        }
                        else
                        {   txtColorButton[3] = (uint32_t)strtoul("0xFF000000", NULL,16);
                            backColorButton[3] = (uint32_t)strtoul("0xFF00FF00", NULL,16);
                        }    
                        touchButtonJPA1(3);                                                                  
                    }             
                }                                     
        }      // end serial bridge message received ----------- 
        if (msgSerial7 > 0) {receiveSerial7();}// serial7 message received - not working ---------------
        if (stringSerial7ok == 1) {printf("Trame Serial7 : %s",stringSerial7);stringSerial7ok=0;}
     
        // timer lcd  --------------------
        if(timer_lcd.read() >= 1000)            // check for timeout
       {    timer_lcd.stop();                       // stop the timer
            timer_lcd.reset();                      // reset the timer
            timer_lcd_on =0;
            BSP_LCD_DisplayOff();
       } 
        // timer send can ------------------------
       if(timer.read_ms() >= 10000)            // check for timeout
       {    timer.stop();                       // stop the timer
            timer.reset();                      // reset the timer
            counter = (counter+1) & 1;                          // increment the counter
            voltage = 0;////(analogIn * 3.3f)/4096.0f;// read the small drifting voltage from analog input
            txMsg.clear();                      // clear the Tx message storage
            txMsg.id = 0x100130CA;//TX_ID;                   // set the message ID
            txMsg.format = CANExtended ; //extended
            txMsg.len=2;
            txMsg.data[0]=8;txMsg.data[1]=counter;        // append data (total data length must be <= 8 bytes!)           
            if(can.write(txMsg))       // transmit message
            {   //if(can->write(txMsg)) {             // transmit the CAN message
                printf("TX CAN OK \n");
                printMsg(txMsg,0);
                //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                //BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
            }
            else
            {   //serialUSB.printf("Transmission error\r\n");
                printf("TX CAN Fail \n");
                //BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
            }    
            timer.start();                  // insert transmission lag
        }  // end if timer send can -------------------
        // touch screen detection -------------------------------
        int xx = touchJPA1();  //       
        if (xx > 0) // touch detected
        {  if (xx==9)  // display pressed but not a touch
           {  timer_lcd.stop();                       // stop the timer
              timer_lcd.reset();                      // reset the timer
              /////////BSP_LCD_DisplayOn();
           }    
           if (xx == 4)  // touch 4 pressed
           {  // send trame to can
              txMsg.id = 0x100130CB;//TX_ID;                   // set the message ID
              txMsg.format = CANExtended ; //extended
              txMsg.len=2;
              txMsg.data[0]=8;txMsg.data[1]=2;        // append data (total data length must be <= 8 bytes!)        
              if(can.write(txMsg))       // transmit message
              {   printMsg(txMsg,0);
                  printf("TX CAN OK \n");
                  //BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"TX CAN OK", CENTER_MODE);
                  //BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"--------", CENTER_MODE);
              }
              else
              {   printf("TX CAN Fail \n");
                  BSP_LCD_DisplayStringAt(0, LINE(4), (uint8_t *)"TX CAN Fail", CENTER_MODE);
                  BSP_LCD_DisplayStringAt(0, LINE(3), (uint8_t *)"-----------", CENTER_MODE);
              }    
           }    
           xx = sendTouchJPA(xx);              
           lastToucheTime = time(NULL);          
        } 
        else 
        {  lastToucheTime = 0;
        }   // send mqtt
        // Update sensor data to GroveStreams
        time_t seconds = time(NULL);
        if(seconds - lastSuccessfulUploadTime > updateFrequency) {
            ////lcd.clear();            
            ////lcd.printf("Getting Samples...");
            printf("Getting Samples...\n");          
            //Assemble the samples into URL parameters which are seperated with the "&" character
            // Example: &s1=6.2&s2=78.231
            int temperature = 0; //adc_temp.read() * 100.0f;
            int voltage = 0; //adc_vref.read() * 100.0f;
            char samples[64] = {0};
            sprintf(samples, "&%s=%d&%s=%d", gsStreamId1, voltage, gsStreamId2, temperature);           
            //Append on command requests (request stream values)
            //This will indicate to GroveStreams to return the last value
            // of each request stream during the sample upload
            strcat(samples, "&rsid=freq&rsid=led");            
            char resultBuffer[700]= {0};
            //Sending Samples (and returning current command stream values)
            time_t connectAttemptTime = time(NULL);
/////////            int sendResult = groveStreams.send(myMac, samples, gsCompName, gsCompTmplId, resultBuffer, sizeof resultBuffer);  //receive mqtt
            int sendResult = 0;
            if (sendResult == 0) {
                ////lcd.printf("Send Successful");
                printf("Send Successful\n");
                lastSuccessfulUploadTime = connectAttemptTime;               
                //Handle command streams
                if (strlen(resultBuffer) > 0 && resultBuffer[0] == '{') {
                    MbedJSONValue mbedJson;
                    parse(mbedJson, resultBuffer);                    
                    sprintf((char*)text, "HTTP string : %s\n", resultBuffer);
                    //BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)&text, LEFT_MODE);                
                    if (mbedJson.hasMember("Temp1")) {
                        int pp=setTemp1(mbedJson["Temp1"].get<std::string>());
                    }
                    if (mbedJson.hasMember("Temp2")) {
                        int tt=setTemp2(mbedJson["Temp2"].get<std::string>());
                    }
                    if (mbedJson.hasMember("led")) {
                        //Change LED
                        myled = mbedJson["led"].get<bool>() ? 1 : 0;
                        ////lcd.printf("LED: %s", mbedJson["led"].get<bool>() ? "On" : "Off");
                        printf("LED: %s\n", mbedJson["led"].get<bool>() ? "On" : "Off");
                    }
                }
            } 
        }
        
    }
}


