/*   
var LCD_COLOR_BLUE          = "0xFF0000FF";
var LCD_COLOR_GREEN         = "0xFF00FF00";
var LCD_COLOR_RED           = "0xFFFF0000";
var LCD_COLOR_CYAN          = "0xFF00FFFF";
var LCD_COLOR_MAGENTA       = "0xFFFF00FF";
var LCD_COLOR_YELLOW        = "0xFFFFFF00";
var LCD_COLOR_LIGHTBLUE     = "0xFF8080FF";
var LCD_COLOR_LIGHTGREEN    = "0xFF80FF80";
var LCD_COLOR_LIGHTRED      = "0xFFFF8080";
var LCD_COLOR_LIGHTCYAN     = "0xFF80FFFF";
var LCD_COLOR_LIGHTMAGENTA  = "0xFFFF80FF";
var LCD_COLOR_LIGHTYELLOW   = "0xFFFFFF80";
var LCD_COLOR_DARKBLUE      = "0xFF000080";
var LCD_COLOR_DARKGREEN     = "0xFF008000";
var LCD_COLOR_DARKRED       = "0xFF800000";
var LCD_COLOR_DARKCYAN      = "0xFF008080";
var LCD_COLOR_DARKMAGENTA   = "0xFF800080";
var LCD_COLOR_DARKYELLOW    = "0xFF808000";
var LCD_COLOR_WHITE         = "0xFFFFFFFF";
var LCD_COLOR_LIGHTGRAY     = "0xFFD3D3D3";
var LCD_COLOR_GRAY          = "0xFF808080";
var LCD_COLOR_DARKGRAY      = "0xFF404040";
var LCD_COLOR_BLACK         = "0xFF000000";
var LCD_COLOR_BROWN         = "0xFFA52A2A";
var LCD_COLOR_ORANGE        = "0xFFFFA500";
var LCD_COLOR_TRANSPARENT   = "0xFF000000";
*/

#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "MbedJSONValue.h"
#include "GroveStreams.h"
//#include <string>

int touchButtonJPA1(int numButton);
extern uint32_t backColorButton[5];
extern uint32_t txtColorButton[5];
char textButton[5][30];
char text1Button[5][30];
extern char statusButton[5][30];

extern int ethernet_actif ;  // use ethernet connection
extern int wifi_actif ;  // use wifi connection

uint32_t backColorTemp1=LCD_COLOR_BLACK, txtColorTemp1=LCD_COLOR_GREEN;
uint32_t backColorTemp2=LCD_COLOR_BLACK, txtColorTemp2=LCD_COLOR_GREEN;
int xTempTitle[3],yTempTitle[3],dxTempTitle[3],dyTempTitle[3],xTxtTempTitle[3],yTxtTempTitle[3];
uint32_t backColorTempTitle[3], txtColorTempTitle[3];
char textTempTitle[3][30];
// GroveStreams Settings
extern const char gsApiKey[] = "YOUR_SECRET_API_KEY_HERE";   //Change This!!!
extern const char gsCompName[] = "STM32F746+Discovery";  //Optionally change. Set this to give your component a name when it initially registers. Encode special chars such as spaces.
extern const char gsCompTmplId[]= "";  //Optional. Tells GS what template to use when the feed initially arrives and a new component needs to be created.
////GroveStreams groveStreams(gsApiKey, &lcd);
//extern GroveStreams groveStreams;
extern const char* myMac;
int displayOn = 0;

// ----------------------------------------------------
int setTemp1(std::string temp1)
  { printf("\nTemp1 : %s\n", temp1.c_str());
    BSP_LCD_SetBackColor(backColorTemp1);
    BSP_LCD_SetTextColor(txtColorTemp1);
    BSP_LCD_SetFont(&FontFreeMono64); 
    BSP_LCD_DisplayStringAt(10, 60, (uint8_t *)temp1.c_str(), LEFT_MODE);
    BSP_LCD_SetFont(&Font12);
    return 1;
    } 
// ------------------------------------------------
int setTemp2(std::string temp2)
  { printf("\nTemp2 : %s\n", temp2.c_str());
    BSP_LCD_SetBackColor(backColorTemp2);
    BSP_LCD_SetTextColor(txtColorTemp2);
    BSP_LCD_SetFont(&FontFreeMono64); 
    BSP_LCD_DisplayStringAt(260, 60, (uint8_t *)temp2.c_str(), LEFT_MODE);
    BSP_LCD_SetFont(&Font12);
    return 1;
    } 
    
// ------------------------------------------------------------
int setDisplayTemp()
  { int numTemp=0;    
    for (numTemp=1;numTemp<3;numTemp=numTemp+1)
      {  BSP_LCD_SetFont(&Font16); 
         BSP_LCD_SetBackColor(backColorTempTitle[numTemp]);
         BSP_LCD_SetTextColor(backColorTempTitle[numTemp]);
         BSP_LCD_FillRect(xTempTitle[numTemp], yTempTitle[numTemp], dxTempTitle[numTemp], dyTempTitle[numTemp]);
         BSP_LCD_SetTextColor(txtColorTempTitle[numTemp]);
         BSP_LCD_DrawRect(xTempTitle[numTemp], yTempTitle[numTemp], dxTempTitle[numTemp], dyTempTitle[numTemp]);
         BSP_LCD_DisplayStringAt(xTxtTempTitle[numTemp], yTxtTempTitle[numTemp], (uint8_t *)textTempTitle[numTemp], LEFT_MODE);
        }
    BSP_LCD_SetFont(&Font8); 
    return 1;   
    }

// -------------------------------------------------------
int initDisplayTemp()
   { printf("\nInit DisplayTemp \n");        
     xTempTitle[1]=14;yTempTitle[1]=30;
     dxTempTitle[1]=200;dyTempTitle[1]=23;
     xTxtTempTitle[1]=15;yTxtTempTitle[1]=34;
     backColorTempTitle[1]=LCD_COLOR_BLACK;txtColorTempTitle[1]=LCD_COLOR_GREEN;
     //sprintf(textTempTitle[1],"   temp Salon  ");    
     xTempTitle[2]=264;yTempTitle[2]=30;dxTempTitle[2]=200;dyTempTitle[2]=23;xTxtTempTitle[2]=265;yTxtTempTitle[2]=34;
     backColorTempTitle[2]=LCD_COLOR_BLACK;txtColorTempTitle[2]=LCD_COLOR_GREEN;
     // sprintf(textTempTitle[2],"   temp Ext    ");    
     int xx=setDisplayTemp();
    return 1;
    }
    
// ------------------------------------------------------------
int initDatasGuiJPA()
    {       ////lcd.clear();          
            ////lcd.printf("Getting Samples...");
            printf("Getting Samples...\n");           
            //Assemble the samples into URL parameters which are seperated with the "&" character
            // Example: &s1=6.2&s2=78.231
            char samples[64] = {0};
            sprintf(samples, "&datas=init");            
            //Append on command requests (request stream values)
            //This will indicate to GroveStreams to return the last value
            // of each request stream during the sample upload
            //strcat(samples, "&rsid=freq&rsid=led");           
            char resultBuffer[2000]= {0};
            //Sending Samples (and returning current command stream values)
            int sendResult=1;
            printf("InitDataGuiJPA - Ethernet actif %i \n", ethernet_actif); 
                        
            if (ethernet_actif == 0)  // ethernet inactif -------------------------------------
            {  // on n'utilise pas ethernet. lecture valeurs from sdcard
               printf("Use local graphic datas\n"); 
               // display temp1  window                     
               // display temp2
               // add wifi test. 
               // if wifi actif  send request tasmota to retrieve   values text box & buttons status
               if (wifi_actif == 0)  
               {   // si wifi actif launch tasmota request
               
                   // reteive tasmota results to display
               }    
               backColorTemp1 = (uint32_t)strtoul("0xFF808080", NULL,16); //gray
               txtColorTemp1 = (uint32_t)strtoul("0xFFFFFF00", NULL,16) ;
               backColorTemp2 = (uint32_t)strtoul("0xFF808080", NULL,16);
               txtColorTemp2 = (uint32_t)strtoul("0xFFFFFF00", NULL,16) ;
               displayOn = (0x01 | displayOn);// display temp1 & temp2 box 
               displayOn = (0x02 | displayOn); // touche 1
               displayOn = (0x04 | displayOn); // touche 2
               displayOn = (0x08 | displayOn); // touche 3
               displayOn = (0x10 | displayOn); //touche  4
               if ((displayOn & 0x02) > 0) {touchButtonJPA1(1);}
                    if ((displayOn & 0x04) > 0) {touchButtonJPA1(2);}
                    if ((displayOn & 0x08) > 0) {touchButtonJPA1(3);}
                    if ((displayOn & 0x10) > 0) {touchButtonJPA1(4);}                           
            }
            else
            {    
 ///////////           sendResult = groveStreams.sendInitDatasJPA(myMac, samples, gsCompName, gsCompTmplId, resultBuffer, sizeof resultBuffer);
            if (sendResult == 0) 
            {   ////lcd.printf("Send Successful");
                printf("Send Successful\n");               
                //Handle command streams
                if (strlen(resultBuffer) > 0 && resultBuffer[0] == '{') 
                {   printf("Datas : %s\n",resultBuffer);
                    MbedJSONValue mbedJson;
                    parse(mbedJson, resultBuffer);       
                    //sprintf((char*)text, "HTTP string : %s\n", resultBuffer);
                    //BSP_LCD_DisplayStringAt(0, LINE(10), (uint8_t *)&text, LEFT_MODE);
                    //int displayOn = 0;
                    string s;
                    if (mbedJson.hasMember("Temp1")) 
                    {   s = mbedJson["Temp1"]["backColorTemp"].get<std::string>();
                        backColorTemp1 = (uint32_t)strtoul(s.c_str(), NULL,16);
                        //printf("Temp1 backColorTemp1 : %s %X\n",s.c_str(),(uint32_t)strtoul(s.c_str(), NULL,0));
                        s = mbedJson["Temp1"]["txtColorTemp"].get<std::string>();
                        txtColorTemp1 = (uint32_t)strtoul(s.c_str(), NULL,16) ;
                        //printf("Temp1 txtColorTemp1 : %s %X\n",s.c_str(),(uint32_t)strtoul(s.c_str(), NULL,0));
                        s = mbedJson["Temp1"]["text"].get<std::string>();
                        sprintf(textTempTitle[1],s.c_str());
                        printf("Temp1 text : %s\n",s.c_str());
                        displayOn = (0x01 | displayOn);
                    }
                    if (mbedJson.hasMember("Temp2")) 
                    {   s = mbedJson["Temp2"]["backColorTemp"].get<std::string>();
                        backColorTemp2 = (uint32_t)strtoul(s.c_str(), NULL,16);
                        //printf("Temp2 text : %s\n",s.c_str());
                        s = mbedJson["Temp2"]["txtColorTemp"].get<std::string>();
                        txtColorTemp2 = (uint32_t)strtoul(s.c_str(), NULL,16) ;
                        //printf("Temp2 backColorTemp2 : %s\n",s.c_str());
                        s = mbedJson["Temp2"]["text"].get<std::string>();
                        sprintf(textTempTitle[2],s.c_str());
                        printf("Temp2 text : %s\n",s.c_str());
                        displayOn = (0x01 | displayOn);
                    }                   
                    if (mbedJson.hasMember("Touche1")) 
                    {   s = mbedJson["Touche1"]["Status"].get<std::string>();
                        sprintf(statusButton[1],s.c_str());
                        printf("Touche1 Status : %s\n",s.c_str());
                        s = mbedJson["Touche1"]["BackColor"].get<std::string>();
                        backColorButton[1] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche1 BackColor : %s\n",s.c_str());
                        s = mbedJson["Touche1"]["TextColor"].get<std::string>();
                        txtColorButton[1] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche1 TextColor : %s\n",s.c_str());
                        s = mbedJson["Touche1"]["text"].get<std::string>();
                        sprintf(textButton[1],s.c_str());
                        printf("Touche1 text : %s\n",s.c_str());
                        s = mbedJson["Touche1"]["text1"].get<std::string>();
                        sprintf(text1Button[1],s.c_str());
                        printf("Touche1 text1 : %s\n",s.c_str());
                        displayOn = (0x02 | displayOn);
                    }                                                               
                    if (mbedJson.hasMember("Touche2")) 
                    {   s = mbedJson["Touche2"]["Status"].get<std::string>();
                        sprintf(statusButton[2],s.c_str());
                        printf("Touche2 Status : %s\n",s.c_str());
                        s = mbedJson["Touche2"]["BackColor"].get<std::string>();
                        backColorButton[2] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche1 BackColor : %s\n",s.c_str());
                        s = mbedJson["Touche2"]["TextColor"].get<std::string>();
                        txtColorButton[2] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche2 TextColor : %s\n",s.c_str());
                        s = mbedJson["Touche2"]["text"].get<std::string>();
                        sprintf(textButton[2],s.c_str());
                        printf("Touche2 text : %s\n",s.c_str());
                        s = mbedJson["Touche2"]["text1"].get<std::string>();
                        sprintf(text1Button[2],s.c_str());
                        printf("Touche2 text1 : %s\n",s.c_str());
                        displayOn = (0x04 | displayOn);
                    }
                    if (mbedJson.hasMember("Touche3")) 
                    {   s = mbedJson["Touche3"]["Status"].get<std::string>();
                        sprintf(statusButton[3],s.c_str());
                        printf("Touche3 Status : %s\n",s.c_str());
                        s = mbedJson["Touche3"]["BackColor"].get<std::string>();
                        backColorButton[3] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche3 BackColor : %s\n",s.c_str());
                        s = mbedJson["Touche3"]["TextColor"].get<std::string>();
                        txtColorButton[3] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche3 TextColor : %s\n",s.c_str());
                        s = mbedJson["Touche3"]["text"].get<std::string>();
                        sprintf(textButton[3],s.c_str());
                        printf("Touche3 text : %s\n",s.c_str());
                        s = mbedJson["Touche3"]["text1"].get<std::string>();
                        sprintf(text1Button[3],s.c_str());
                        printf("Touche3 text1 : %s\n",s.c_str());
                        displayOn = (0x08 | displayOn);
                    }
                    if (mbedJson.hasMember("Touche4")) 
                    {   s = mbedJson["Touche4"]["Status"].get<std::string>();
                        sprintf(statusButton[4],s.c_str());
                        printf("Touche4 Status : %s\n",s.c_str());
                        s = mbedJson["Touche4"]["BackColor"].get<std::string>();
                        backColorButton[4] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche4 BackColor : %s\n",s.c_str());
                        s = mbedJson["Touche4"]["TextColor"].get<std::string>();
                        txtColorButton[4] = (uint32_t)strtoul(s.c_str(), NULL,16);
                        printf("Touche4 TextColor : %s\n",s.c_str());
                        s = mbedJson["Touche4"]["text"].get<std::string>();
                        sprintf(textButton[4],s.c_str());
                        printf("Touche4 text : %s\n",s.c_str());
                        s = mbedJson["Touche4"]["text1"].get<std::string>();
                        sprintf(text1Button[4],s.c_str());
                        printf("Touche4 text1 : %s\n",s.c_str());
                        displayOn = (0x10 | displayOn);
                    }
                    if (mbedJson.hasMember("Temp1")) 
                    {   //int pp=setTemp1(mbedJson["Temp1"].get<std::string>());
                    }
                    if (mbedJson.hasMember("Temp2")) 
                    {   //int pp=setTemp1(mbedJson["Temp2"].get<std::string>());
                    }                    
                    
                    if ((displayOn & 0x02) > 0) {touchButtonJPA1(1);}
                    if ((displayOn & 0x04) > 0) {touchButtonJPA1(2);}
                    if ((displayOn & 0x08) > 0) {touchButtonJPA1(3);}
                    if ((displayOn & 0x10) > 0) {touchButtonJPA1(4);}
                }
            }  // fin test send result
            }  // fin test ethernet actif
            if ((displayOn & 0x01) > 0) {setDisplayTemp();}            
        return 1; 
        }   

