
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "mbed.h"
//#include "GroveStreams.h"
#include "MbedJSONValue.h"
Timer    timer_touch[16];
Timer           timer_lcd;

void sendSerial2(char * str);
void sendSerial7(char * str);

int initDisplayTemp();
// GroveStreams Settings
//extern const char gsApiKey[];// = "YOUR_SECRET_API_KEY_HERE";   //Change This!!!
extern const char gsCompName[];// = "STM32F746+Discovery";  //Optionally change. Set this to give your component a name when it initially registers. Encode special chars such as spaces.
extern const char gsCompTmplId[];  //Optional. Tells GS what template to use when the feed initially arrives and a new component needs to be created.
////GroveStreams groveStreams(gsApiKey, &lcd);
//extern GroveStreams groveStreams;
extern const char* myMac;
extern time_t seconds;
time_t seconds_touches = 0;
extern time_t lastToucheTime;  
// char touch1_text1;
extern int ethernet_actif ;  // use ethernet connection
extern int wifi_actif ;  // use wifi connection

// -----------------------------------------------------------------
int touchInitJPA1()
    {    //touch screen init
    //touch screen
    uint8_t status;  
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_SetFont(&Font12); 
    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) 
    {   BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    }
    else 
    {   BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        //BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }  
    int tt = 0;
    for (tt=0;tt<16;tt++) 
    {   if(timer_touch[tt].read_ms() > 500) 
        {  timer_touch[tt].stop();timer_touch[tt].reset();
        }
    }
    return 0;   
    }
// -------------------------------------------------------
int xButton[5],yButton[5],dxButton[5],dyButton[5],xTxtButton[5],yTxtButton[5];
uint32_t backColorButton[5], txtColorButton[5];
extern char textButton[5][8];
extern char text1Button[5][8];
char statusButton[5][30];

// -----------------------------------------------------------------------------------------
int touchButtonJPA1(int numButton)
  { if ((numButton > 0) && (numButton < 5))
     {  BSP_LCD_SetBackColor(backColorButton[numButton]);
        BSP_LCD_SetTextColor(backColorButton[numButton]);
        BSP_LCD_FillRect(xButton[numButton], yButton[numButton], dxButton[numButton], dyButton[numButton]);
        BSP_LCD_SetTextColor(txtColorButton[numButton]);
        BSP_LCD_DrawRect(xButton[numButton], yButton[numButton], dxButton[numButton], dyButton[numButton]);
        BSP_LCD_SetFont(&Font20); 
        BSP_LCD_DisplayStringAt(xTxtButton[numButton]+52, yTxtButton[numButton], (uint8_t *)statusButton[numButton], LEFT_MODE);
        BSP_LCD_DisplayStringAt(xTxtButton[numButton], yTxtButton[numButton]+28, (uint8_t *)textButton[numButton], LEFT_MODE);
        BSP_LCD_DisplayStringAt(xTxtButton[numButton], yTxtButton[numButton]+48, (uint8_t *)text1Button[numButton], LEFT_MODE);
        }
    return 0;
    }

// ----------------------------------------------------------------------------------
// generation de fonts : http://omz-software.com/pythonista/docs/ios/ImageFont.html
int touchInitGuiJPA1()
    {  // button 1 en bas a gauche 
    xButton[1]=10;yButton[1]=185;dxButton[1]=100;dyButton[1]=80;xTxtButton[1]=12;yTxtButton[1]=190;
    backColorButton[1] = LCD_COLOR_GRAY; 
    txtColorButton[1] = LCD_COLOR_GREEN;    
    //sprintf(textButton[1],"Lampe ");
    //sprintf(text1Button[1],"Sejour");
    sprintf(statusButton[1],"off");
    // bouton 2 a cote bouton 1
    xButton[2]=130;yButton[2]=185;dxButton[2]=100;dyButton[2]=80;xTxtButton[2]=132;yTxtButton[2]=190;
    backColorButton[2] = LCD_COLOR_GRAY; txtColorButton[2] = LCD_COLOR_GREEN;
    //sprintf(textButton[2],"Lampe ");
    //sprintf(text1Button[2],"Sejours");
    sprintf(statusButton[2],"off");
    // bouton 3   
    xButton[3]=250;yButton[3]=185;dxButton[3]=100;dyButton[3]=80;xTxtButton[3]=252;yTxtButton[3]=190;
    backColorButton[3] = LCD_COLOR_GRAY; txtColorButton[3] = LCD_COLOR_GREEN;
    //sprintf(textButton[3],"Lampe ");
    //sprintf(text1Button[3],"Sejour");
    sprintf(statusButton[3],"off");
    // bouton 4 en bas a ddroite   
    xButton[4]=370;yButton[4]=185;dxButton[4]=100;dyButton[4]=80;xTxtButton[4]=372;yTxtButton[4]=190;
    backColorButton[4] = LCD_COLOR_GRAY; txtColorButton[4] = LCD_COLOR_GREEN;
    //sprintf(textButton[4],"Lampe ");
    //sprintf(text1Button[4],"Sejour");
    sprintf(statusButton[4],"off");

    touchButtonJPA1(1);
    touchButtonJPA1(2);
    touchButtonJPA1(3);
    touchButtonJPA1(4);
    
    BSP_LCD_SetFont(&FontFreeMono64); 
    //BSP_LCD_DisplayStringAt(20, 30, (uint8_t *)"0123456789", LEFT_MODE);
    //BSP_LCD_DisplayCharJPA(20, 90, '8');
    BSP_LCD_SetFont(&Font12); 
    return 0; 
    }

// --------------------------------------------------------------------------    
int touchJPA1()
    { //touch screen
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status = 0;
    uint8_t idx;
    static uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;  
        int tt = 0;
        for (tt=0;tt<16;tt++) 
            {if(timer_touch[tt].read_ms() > 200) 
                {timer_touch[tt].stop();timer_touch[tt].reset();}}
        //touch screen
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    //BSP_LCD_ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;            
            cleared = 0;
            //sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            //BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                //sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                //BSP_LCD_DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }
            
            //BSP_LCD_DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);           
            if ((TS_State.touchY[0] > 160) && (TS_State.touchY[0] < (160+80)))
                { int numTouche = 0;
                if ((TS_State.touchX[0] > 10) && (TS_State.touchX[0]  < (10+100)))  
                    {if(timer_touch[0].read_ms() == 0) {numTouche = 1;timer_touch[0].start();}}
                if ((TS_State.touchX[0] > 130) && (TS_State.touchX[0] < (130+100))) 
                    {if(timer_touch[1].read_ms() == 0) {numTouche = 2;timer_touch[1].start();}}
                if ((TS_State.touchX[0] > 250) && (TS_State.touchX[0] < (250+100))) 
                    {if(timer_touch[2].read_ms() == 0) {numTouche = 3;timer_touch[2].start();}}
                if ((TS_State.touchX[0] > 370) && (TS_State.touchX[0] < (370+100))) 
                    {if(timer_touch[3].read_ms() == 0) {numTouche = 4;timer_touch[3].start();}}
                if (numTouche >0) 
                    { printf("Touche : %d", numTouche);
                    sprintf((char*)text, "Touche : %d", numTouche);
                    //BSP_LCD_DisplayStringAt(200,0, (uint8_t *)&text, LEFT_MODE);
                    status = numTouche;
                    }  
                else 
                   {lastToucheTime = 0;
                   }
                }
            else
               { 
               int numTouche = 9;
               printf("Touche : %d", numTouche);
               timer_lcd.stop();                       // stop the timer
               timer_lcd.reset();                      // reset the timer
               BSP_LCD_DisplayOn();
               }   
        } else {
            lastToucheTime = 0;
            if (!cleared) {
                //BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
                //sprintf((char*)text, "Touches: 0");
                //BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                //cleared = 1;
                //int ss = touchInitGuiJPA1();
                //ss=initDisplayTemp();
            }
        }
        //touch screen    
    return status;
    }
 
 // -----------------------------------------------------------------------   
int sendTouchJPA(int xx)
    {   uint8_t status = 0;
        seconds = time(NULL);
        if((seconds - lastToucheTime) > 1) 
        {    char samples[64] = {0};char resultBuffer[2000]= {0};
             sprintf(samples,"&Touche=%i",xx);
             printf("\nSend Touche=%i\n",xx);               
             // modifier pour rajouter test ethernet / wifi et action en fonction                 
             if (ethernet_actif == 1 )  // ethernet actif
             {   printf("\ntraitement Ethernet\n",xx);               
/////////////  int sendResult = groveStreams.sendJPA(myMac, samples, gsCompName, gsCompTmplId, resultBuffer, sizeof resultBuffer);
                 int sendResult = 0;
                 if (sendResult == 0) 
                 {      ////lcd.printf("Send Successful");
                        printf("Send Successful\n");
                        if (strlen(resultBuffer) > 0) 
                        {   //printf("HTTP string : %s\n", resultBuffer);
                            MbedJSONValue mbedJson;
                            parse(mbedJson, resultBuffer);                            
                            int displayOn = 0;
                            string s;
                            if (mbedJson.hasMember("Touche1")) 
                            {    s = mbedJson["Touche1"]["BackColor"].get<std::string>();
                                backColorButton[1] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche1"]["TextColor"].get<std::string>();
                                txtColorButton[1] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche1"]["Status"].get<std::string>();
                                sprintf(statusButton[1],s.c_str());
                                displayOn = (0x02 | displayOn);
                            }
                             if (mbedJson.hasMember("Touche2")) 
                             {   s = mbedJson["Touche2"]["BackColor"].get<std::string>();
                                backColorButton[2] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche2"]["TextColor"].get<std::string>();
                                txtColorButton[2] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche2"]["Status"].get<std::string>();
                                sprintf(statusButton[2],s.c_str());
                                displayOn = (0x04 | displayOn);
                            }
                            if (mbedJson.hasMember("Touche3")) 
                            {    s = mbedJson["Touche3"]["BackColor"].get<std::string>();
                                backColorButton[3] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche3"]["TextColor"].get<std::string>();
                                txtColorButton[3] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche3"]["Status"].get<std::string>();
                                sprintf(statusButton[3],s.c_str());
                                displayOn = (0x08 | displayOn);
                            }    
                            if (mbedJson.hasMember("Touche4")) 
                            {    s = mbedJson["Touche4"]["BackColor"].get<std::string>();
                                backColorButton[4] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche4"]["TextColor"].get<std::string>();
                                txtColorButton[4] = (uint32_t)strtoul(s.c_str(), NULL,16);
                                s = mbedJson["Touche4"]["Status"].get<std::string>();
                                sprintf(statusButton[4],s.c_str());
                                displayOn = (0x10 | displayOn);  
                            }                                 
                            if ((displayOn & 0x02) > 0) {touchButtonJPA1(1);}
                            if ((displayOn & 0x04) > 0) {touchButtonJPA1(2);}
                            if ((displayOn & 0x08) > 0) {touchButtonJPA1(3);}
                            if ((displayOn & 0x10) > 0) {touchButtonJPA1(4);}
                         }// fin test result buffer
                      } // fin test send result                   
                }  // fin test ethernet actif
                else if (wifi_actif == 1)  // wifi actif --------------------------------
                {   // send trame to wifi to inform touch pressed
                    printf("\nSend Touche=%i status=%s \n ",xx,statusButton[4] ); 
                    // {"Touche":{ "No":"4","Statusl":"Off"}}
                    sprintf(samples,"{\"Touche\":{\"No\":\"%i\",\"Status\":\"%s\"}}",xx,statusButton[xx]);
                    printf(samples); 
                    printf ("\n");                  
                    sendSerial2(samples);
                 }   
                else      // traitement en local
                {  printf("\nTraitement local\n");                     
                }                                              
             }    
    return status;    
    }
