
#include "PSDdetection.h"

Arm::Arm(){
	for (int i = 0; i<4; i++)
		prevEMG[i] = 0;

	EMGreference = 140;
}

// Sets a new reference level
void Arm::setReference(int reflevel){
	this->EMGreference = reflevel;
}

// Updates the array with a new sample and checks wheter a muscle is active
bool Arm::checksample(int emgsample){

	bool MuscleIsActive = false;

	// Shift all the previous values in time
	for (int i = 3; i>0; i--){
		prevEMG[i] = prevEMG[i - 1];
	}

	// Put in the latest sample
	prevEMG[0] = emgsample;

	// Weighted average filter to smoothen out the response
	int average = (prevEMG[0] * 1 + prevEMG[1] * 0.63 + prevEMG[2] * 0.45 + prevEMG[3] * 0.22) / (1 + 0.63 + 0.45 + 0.22);

	// Check with reference level to determine if it is 
	if (average > (EMGreference + EMGtriggerlevel)){
		MuscleIsActive = true;
	}

	return MuscleIsActive;
}

int biquad10(int emgsample){
	//initialize filter values 
	float filteredValue,a0,a1,a2,b1,b2;
	float intermediateValue1[2]intermediateValue2[2];
	//filter for 10hz -6bd biquad
	a0=0.0009446857782217186;
	a1=0.0018893715564434373;
	a2=0.0009446857782217186;
	b1=-1.9111847961312216;
	b2=0.9149635392441086;
	//calculations for transposed direct form 2
	intermediateValue1[0] = a2*emgsample-b2*filteredValue;
	intermediateValue2[0] = a2*emgsample-b1*filteredValue+intermediateValue1[1];
	filteredValue = a0*filteredValue+intermediateValue2[1];
	intermediateValue1[1] = intermediateValue1[0];
	intermediateValue2[1] = intermediateValue2[0];
	
	
	return ((int)filteredValue);
	}