
//
// This file contains all the lookup tables needed for the robot
//

#pragma once
#ifndef _LOOKUP_TABLES_H
#define _LOOKUP_TABLES_H

#define M_PI           3.14159265358979323846


////////////////// COSINE SINE LOOKUP TABLES
// 10 bit lookup table for the cosine function (NOTE lookup table for the sine is generated with an offset)
const float cosLookupTable_f[] = { 1, 0.999981, 0.999925, 0.999831, 0.999699, 0.999529, 0.999322, 0.999078, 0.998795, 0.998476, 0.998118, 0.997723, 0.99729, 0.99682, 0.996313, 0.995767, 0.995185, 0.994565, 0.993907, 0.993212, 0.99248, 0.99171, 0.990903, 0.990058, 0.989177, 0.988258, 0.987301, 0.986308, 0.985278, 0.98421, 0.983105, 0.981964, 0.980785, 0.97957, 0.978317, 0.977028, 0.975702, 0.974339, 0.97294, 0.971504, 0.970031, 0.968522, 0.966976, 0.965394, 0.963776, 0.962121, 0.960431, 0.958703, 0.95694, 0.955141, 0.953306, 0.951435, 0.949528, 0.947586, 0.945607, 0.943593, 0.941544, 0.939459, 0.937339, 0.935184, 0.932993, 0.930767, 0.928506, 0.92621, 0.92388, 0.921514, 0.919114, 0.916679, 0.91421, 0.911706, 0.909168, 0.906596, 0.903989, 0.901349, 0.898674, 0.895966, 0.893224, 0.890449, 0.88764, 0.884797, 0.881921, 0.879012, 0.87607, 0.873095, 0.870087, 0.867046, 0.863973, 0.860867, 0.857729, 0.854558, 0.851355, 0.84812, 0.844854, 0.841555, 0.838225, 0.834863, 0.83147, 0.828045, 0.824589, 0.821102, 0.817585, 0.814036, 0.810457, 0.806848, 0.803208, 0.799537, 0.795837, 0.792107, 0.788346, 0.784557, 0.780737, 0.776888, 0.77301, 0.769103, 0.765167, 0.761202, 0.757209, 0.753187, 0.749136, 0.745058, 0.740951, 0.736817, 0.732654, 0.728464, 0.724247, 0.720002, 0.715731, 0.711432, 0.707107, 0.702755, 0.698376, 0.693971, 0.689541, 0.685084, 0.680601, 0.676093, 0.671559, 0.667, 0.662416, 0.657807, 0.653173, 0.648514, 0.643832, 0.639124, 0.634393, 0.629638, 0.624859, 0.620057, 0.615232, 0.610383, 0.605511, 0.600616, 0.595699, 0.59076, 0.585798, 0.580814, 0.575808, 0.570781, 0.565732, 0.560662, 0.55557, 0.550458, 0.545325, 0.540172, 0.534998, 0.529804, 0.52459, 0.519356, 0.514103, 0.50883, 0.503538, 0.498228, 0.492898, 0.48755, 0.482184, 0.476799, 0.471397, 0.465977, 0.460539, 0.455084, 0.449611, 0.444122, 0.438616, 0.433094, 0.427555, 0.422, 0.41643, 0.410843, 0.405241, 0.399624, 0.393992, 0.388345, 0.382683, 0.377007, 0.371317, 0.365613, 0.359895, 0.354163, 0.348419, 0.342661, 0.33689, 0.331106, 0.32531, 0.319502, 0.313682, 0.30785, 0.302006, 0.296151, 0.290285, 0.284407, 0.27852, 0.272621, 0.266713, 0.260794, 0.254866, 0.248928, 0.24298, 0.237024, 0.231058, 0.225084, 0.219101, 0.21311, 0.207111, 0.201105, 0.19509, 0.189069, 0.18304, 0.177004, 0.170962, 0.164913, 0.158858, 0.152797, 0.14673, 0.140658, 0.134581, 0.128498, 0.122411, 0.116319, 0.110222, 0.104122, 0.0980171, 0.0919089, 0.0857973, 0.0796824, 0.0735645, 0.0674438, 0.0613207, 0.0551952, 0.0490676, 0.0429382, 0.0368072, 0.0306747, 0.0245411, 0.0184067, 0.0122715, 0.00613586, -4.37114e-008, -0.00613595, -0.0122716, -0.0184068, -0.0245412, -0.0306748, -0.0368073, -0.0429383, -0.0490677, -0.0551953, -0.0613208, -0.0674439, -0.0735646, -0.0796825, -0.0857974, -0.091909, -0.0980172, -0.104122, -0.110222, -0.116319, -0.122411, -0.128498, -0.134581, -0.140658, -0.146731, -0.152797, -0.158858, -0.164913, -0.170962, -0.177004, -0.18304, -0.189069, -0.19509, -0.201105, -0.207111, -0.21311, -0.219101, -0.225084, -0.231058, -0.237024, -0.24298, -0.248928, -0.254866, -0.260794, -0.266713, -0.272621, -0.27852, -0.284408, -0.290285, -0.296151, -0.302006, -0.30785, -0.313682, -0.319502, -0.32531, -0.331106, -0.33689, -0.342661, -0.348419, -0.354164, -0.359895, -0.365613, -0.371317, -0.377007, -0.382684, -0.388345, -0.393992, -0.399624, -0.405241, -0.410843, -0.41643, -0.422, -0.427555, -0.433094, -0.438616, -0.444122, -0.449611, -0.455084, -0.460539, -0.465977, -0.471397, -0.476799, -0.482184, -0.48755, -0.492898, -0.498228, -0.503538, -0.50883, -0.514103, -0.519356, -0.52459, -0.529804, -0.534998, -0.540172, -0.545325, -0.550458, -0.55557, -0.560662, -0.565732, -0.570781, -0.575808, -0.580814, -0.585798, -0.59076, -0.595699, -0.600617, -0.605511, -0.610383, -0.615232, -0.620057, -0.62486, -0.629638, -0.634393, -0.639124, -0.643832, -0.648514, -0.653173, -0.657807, -0.662416, -0.667, -0.671559, -0.676093, -0.680601, -0.685084, -0.689541, -0.693971, -0.698376, -0.702755, -0.707107, -0.711432, -0.715731, -0.720003, -0.724247, -0.728464, -0.732654, -0.736817, -0.740951, -0.745058, -0.749137, -0.753187, -0.757209, -0.761202, -0.765167, -0.769103, -0.77301, -0.776888, -0.780737, -0.784557, -0.788346, -0.792107, -0.795837, -0.799537, -0.803208, -0.806848, -0.810457, -0.814036, -0.817585, -0.821103, -0.824589, -0.828045, -0.83147, -0.834863, -0.838225, -0.841555, -0.844854, -0.84812, -0.851355, -0.854558, -0.857729, -0.860867, -0.863973, -0.867046, -0.870087, -0.873095, -0.87607, -0.879012, -0.881921, -0.884797, -0.88764, -0.890449, -0.893224, -0.895966, -0.898674, -0.901349, -0.903989, -0.906596, -0.909168, -0.911706, -0.91421, -0.916679, -0.919114, -0.921514, -0.92388, -0.92621, -0.928506, -0.930767, -0.932993, -0.935184, -0.937339, -0.939459, -0.941544, -0.943594, -0.945607, -0.947586, -0.949528, -0.951435, -0.953306, -0.955141, -0.95694, -0.958703, -0.960431, -0.962121, -0.963776, -0.965394, -0.966976, -0.968522, -0.970031, -0.971504, -0.97294, -0.974339, -0.975702, -0.977028, -0.978317, -0.97957, -0.980785, -0.981964, -0.983105, -0.98421, -0.985278, -0.986308, -0.987301, -0.988258, -0.989177, -0.990058, -0.990903, -0.99171, -0.99248, -0.993212, -0.993907, -0.994565, -0.995185, -0.995767, -0.996313, -0.99682, -0.99729, -0.997723, -0.998118, -0.998476, -0.998795, -0.999078, -0.999322, -0.999529, -0.999699, -0.999831, -0.999925, -0.999981, -1, -0.999981, -0.999925, -0.999831, -0.999699, -0.999529, -0.999322, -0.999078, -0.998795, -0.998476, -0.998118, -0.997723, -0.99729, -0.99682, -0.996313, -0.995767, -0.995185, -0.994565, -0.993907, -0.993212, -0.99248, -0.99171, -0.990903, -0.990058, -0.989177, -0.988258, -0.987301, -0.986308, -0.985278, -0.98421, -0.983105, -0.981964, -0.980785, -0.97957, -0.978317, -0.977028, -0.975702, -0.974339, -0.97294, -0.971504, -0.970031, -0.968522, -0.966976, -0.965394, -0.963776, -0.962121, -0.96043, -0.958703, -0.95694, -0.955141, -0.953306, -0.951435, -0.949528, -0.947586, -0.945607, -0.943593, -0.941544, -0.939459, -0.937339, -0.935183, -0.932993, -0.930767, -0.928506, -0.92621, -0.92388, -0.921514, -0.919114, -0.916679, -0.91421, -0.911706, -0.909168, -0.906596, -0.903989, -0.901349, -0.898674, -0.895966, -0.893224, -0.890449, -0.88764, -0.884797, -0.881921, -0.879012, -0.87607, -0.873095, -0.870087, -0.867046, -0.863973, -0.860867, -0.857729, -0.854558, -0.851355, -0.84812, -0.844854, -0.841555, -0.838225, -0.834863, -0.83147, -0.828045, -0.824589, -0.821102, -0.817585, -0.814036, -0.810457, -0.806847, -0.803208, -0.799537, -0.795837, -0.792107, -0.788346, -0.784557, -0.780737, -0.776888, -0.77301, -0.769103, -0.765167, -0.761202, -0.757209, -0.753187, -0.749136, -0.745058, -0.740951, -0.736817, -0.732654, -0.728464, -0.724247, -0.720002, -0.715731, -0.711432, -0.707107, -0.702755, -0.698376, -0.693971, -0.689541, -0.685084, -0.680601, -0.676093, -0.671559, -0.667, -0.662416, -0.657807, -0.653173, -0.648514, -0.643832, -0.639124, -0.634393, -0.629638, -0.62486, -0.620057, -0.615232, -0.610383, -0.605511, -0.600616, -0.595699, -0.59076, -0.585798, -0.580814, -0.575808, -0.570781, -0.565732, -0.560661, -0.55557, -0.550458, -0.545325, -0.540171, -0.534997, -0.529803, -0.524589, -0.519356, -0.514103, -0.50883, -0.503538, -0.498228, -0.492898, -0.48755, -0.482184, -0.476799, -0.471397, -0.465976, -0.460539, -0.455083, -0.449611, -0.444122, -0.438616, -0.433094, -0.427555, -0.422, -0.416429, -0.410843, -0.405241, -0.399624, -0.393992, -0.388345, -0.382683, -0.377007, -0.371317, -0.365613, -0.359895, -0.354164, -0.348419, -0.342661, -0.33689, -0.331106, -0.32531, -0.319502, -0.313682, -0.30785, -0.302006, -0.296151, -0.290285, -0.284407, -0.27852, -0.272621, -0.266713, -0.260794, -0.254865, -0.248927, -0.24298, -0.237023, -0.231058, -0.225084, -0.219101, -0.21311, -0.207111, -0.201105, -0.19509, -0.189069, -0.18304, -0.177004, -0.170962, -0.164913, -0.158858, -0.152797, -0.14673, -0.140658, -0.134581, -0.128498, -0.122411, -0.116318, -0.110222, -0.104121, -0.0980169, -0.0919087, -0.0857971, -0.0796822, -0.0735643, -0.0674436, -0.0613204, -0.0551949, -0.0490673, -0.0429379, -0.0368073, -0.0306749, -0.0245413, -0.0184068, -0.0122716, -0.00613589, 1.19249e-008, 0.00613591, 0.0122716, 0.0184068, 0.0245413, 0.0306749, 0.0368073, 0.0429384, 0.0490678, 0.0551954, 0.0613209, 0.0674441, 0.0735648, 0.0796827, 0.0857976, 0.0919092, 0.0980174, 0.104122, 0.110223, 0.116319, 0.122411, 0.128498, 0.134581, 0.140658, 0.14673, 0.152797, 0.158858, 0.164913, 0.170962, 0.177004, 0.18304, 0.189069, 0.19509, 0.201105, 0.207111, 0.21311, 0.219101, 0.225084, 0.231058, 0.237024, 0.24298, 0.248928, 0.254866, 0.260794, 0.266713, 0.272622, 0.27852, 0.284408, 0.290285, 0.296151, 0.302006, 0.30785, 0.313682, 0.319502, 0.32531, 0.331106, 0.33689, 0.342661, 0.348419, 0.354164, 0.359895, 0.365613, 0.371317, 0.377008, 0.382684, 0.388345, 0.393992, 0.399624, 0.405242, 0.410843, 0.41643, 0.422001, 0.427555, 0.433094, 0.438617, 0.444122, 0.449612, 0.455084, 0.460539, 0.465976, 0.471397, 0.476799, 0.482184, 0.48755, 0.492898, 0.498228, 0.503538, 0.50883, 0.514103, 0.519356, 0.52459, 0.529804, 0.534998, 0.540172, 0.545325, 0.550458, 0.55557, 0.560662, 0.565732, 0.570781, 0.575808, 0.580814, 0.585798, 0.59076, 0.595699, 0.600616, 0.605511, 0.610383, 0.615232, 0.620057, 0.62486, 0.629638, 0.634393, 0.639125, 0.643832, 0.648515, 0.653173, 0.657807, 0.662416, 0.667, 0.671559, 0.676093, 0.680601, 0.685084, 0.689541, 0.693972, 0.698376, 0.702755, 0.707107, 0.711432, 0.715731, 0.720003, 0.724247, 0.728464, 0.732654, 0.736817, 0.740951, 0.745058, 0.749136, 0.753187, 0.757209, 0.761202, 0.765167, 0.769103, 0.773011, 0.776889, 0.780737, 0.784557, 0.788347, 0.792107, 0.795837, 0.799537, 0.803208, 0.806848, 0.810457, 0.814037, 0.817585, 0.821103, 0.824589, 0.828045, 0.83147, 0.834863, 0.838225, 0.841555, 0.844854, 0.84812, 0.851355, 0.854558, 0.857729, 0.860867, 0.863973, 0.867046, 0.870087, 0.873095, 0.87607, 0.879012, 0.881921, 0.884797, 0.88764, 0.890449, 0.893224, 0.895966, 0.898675, 0.901349, 0.903989, 0.906596, 0.909168, 0.911706, 0.91421, 0.916679, 0.919114, 0.921514, 0.92388, 0.92621, 0.928506, 0.930767, 0.932993, 0.935184, 0.937339, 0.939459, 0.941544, 0.943594, 0.945607, 0.947586, 0.949528, 0.951435, 0.953306, 0.955141, 0.95694, 0.958704, 0.960431, 0.962121, 0.963776, 0.965395, 0.966977, 0.968522, 0.970031, 0.971504, 0.97294, 0.974339, 0.975702, 0.977028, 0.978317, 0.97957, 0.980785, 0.981964, 0.983106, 0.98421, 0.985278, 0.986308, 0.987301, 0.988258, 0.989177, 0.990058, 0.990903, 0.99171, 0.99248, 0.993212, 0.993907, 0.994565, 0.995185, 0.995767, 0.996313, 0.99682, 0.99729, 0.997723, 0.998118, 0.998476, 0.998795, 0.999078, 0.999322, 0.999529, 0.999699, 0.999831, 0.999925, 0.999981 };

// Returns the cosine value using the lut of a given value
float lut_cos(float value);
// Returns the sine value using the lut for a given value
float lut_sin(float value);

// Returns the cosine value using the lut of a given value
// WARNING, FAST VERSION ONLY WORKS WITH VALUES 0 - 2 PI
float lut_cos_f(float value);
////////////////// END COSINE SINE LOOKUP TABLES

////////////////// HANNING LOOKUP TABLE
// 10 bit hanning lookup table
const float hanningTable_f[] = { 0, 9.43077e-006, 3.77227e-005, 8.48748e-005, 0.000150885, 0.000235751, 0.00033947, 0.000462038, 0.00060345, 0.0007637, 0.000942783, 0.00114069, 0.00135742, 0.00159296, 0.0018473, 0.00212043, 0.00241234, 0.00272303, 0.00305247, 0.00340066, 0.00376758, 0.00415322, 0.00455757, 0.0049806, 0.00542231, 0.00588268, 0.00636168, 0.00685931, 0.00737554, 0.00791035, 0.00846373, 0.00903565, 0.00962609, 0.010235, 0.0108624, 0.0115083, 0.0121726, 0.0128553, 0.0135564, 0.0142758, 0.0150135, 0.0157696, 0.0165439, 0.0173364, 0.0181472, 0.0189761, 0.0198232, 0.0206884, 0.0215716, 0.022473, 0.0233923, 0.0243296, 0.0252849, 0.026258, 0.027249, 0.0282579, 0.0292846, 0.030329, 0.0313911, 0.0324709, 0.0335684, 0.0346834, 0.035816, 0.0369661, 0.0381337, 0.0393187, 0.0405211, 0.0417408, 0.0429778, 0.044232, 0.0455035, 0.046792, 0.0480977, 0.0494204, 0.0507601, 0.0521168, 0.0534904, 0.0548808, 0.056288, 0.0577119, 0.0591525, 0.0606098, 0.0620836, 0.0635739, 0.0650807, 0.0666039, 0.0681435, 0.0696993, 0.0712714, 0.0728597, 0.0744641, 0.0760845, 0.0777209, 0.0793732, 0.0810414, 0.0827255, 0.0844252, 0.0861406, 0.0878717, 0.0896183, 0.0913804, 0.0931578, 0.0949507, 0.0967588, 0.0985821, 0.100421, 0.102274, 0.104143, 0.106026, 0.107924, 0.109838, 0.111765, 0.113708, 0.115665, 0.117637, 0.119623, 0.121623, 0.123638, 0.125666, 0.127709, 0.129766, 0.131837, 0.133922, 0.136021, 0.138133, 0.140259, 0.142399, 0.144552, 0.146718, 0.148898, 0.151091, 0.153297, 0.155517, 0.157749, 0.159994, 0.162252, 0.164523, 0.166806, 0.169102, 0.171411, 0.173732, 0.176065, 0.17841, 0.180768, 0.183137, 0.185519, 0.187912, 0.190317, 0.192734, 0.195163, 0.197603, 0.200054, 0.202517, 0.20499, 0.207475, 0.209972, 0.212479, 0.214996, 0.217525, 0.220064, 0.222614, 0.225174, 0.227745, 0.230326, 0.232917, 0.235518, 0.238129, 0.24075, 0.243381, 0.246021, 0.248671, 0.251331, 0.254, 0.256678, 0.259365, 0.262062, 0.264767, 0.267482, 0.270205, 0.272936, 0.275677, 0.278425, 0.281183, 0.283948, 0.286721, 0.289503, 0.292293, 0.29509, 0.297895, 0.300708, 0.303528, 0.306355, 0.30919, 0.312033, 0.314882, 0.317738, 0.320601, 0.323471, 0.326347, 0.32923, 0.33212, 0.335016, 0.337918, 0.340826, 0.34374, 0.34666, 0.349586, 0.352518, 0.355455, 0.358397, 0.361345, 0.364298, 0.367256, 0.37022, 0.373188, 0.376161, 0.379138, 0.382121, 0.385107, 0.388098, 0.391093, 0.394092, 0.397096, 0.400103, 0.403114, 0.406128, 0.409146, 0.412168, 0.415193, 0.418221, 0.421252, 0.424286, 0.427323, 0.430363, 0.433405, 0.43645, 0.439497, 0.442547, 0.445598, 0.448652, 0.451708, 0.454765, 0.457824, 0.460885, 0.463948, 0.467011, 0.470076, 0.473142, 0.476209, 0.479277, 0.482346, 0.485415, 0.488485, 0.491555, 0.494626, 0.497697, 0.500768, 0.503839, 0.506909, 0.50998, 0.51305, 0.51612, 0.519189, 0.522257, 0.525325, 0.528391, 0.531457, 0.534521, 0.537584, 0.540645, 0.543705, 0.546764, 0.54982, 0.552875, 0.555928, 0.558978, 0.562027, 0.565073, 0.568116, 0.571157, 0.574196, 0.577231, 0.580264, 0.583294, 0.58632, 0.589343, 0.592363, 0.595379, 0.598392, 0.601401, 0.604406, 0.607408, 0.610405, 0.613398, 0.616387, 0.619371, 0.622351, 0.625326, 0.628297, 0.631263, 0.634223, 0.637179, 0.640129, 0.643075, 0.646015, 0.648949, 0.651878, 0.654801, 0.657718, 0.660629, 0.663534, 0.666433, 0.669326, 0.672212, 0.675092, 0.677965, 0.680831, 0.683691, 0.686544, 0.689389, 0.692228, 0.695059, 0.697883, 0.7007, 0.703509, 0.70631, 0.709103, 0.711889, 0.714666, 0.717436, 0.720197, 0.72295, 0.725695, 0.728431, 0.731158, 0.733877, 0.736587, 0.739287, 0.741979, 0.744662, 0.747336, 0.75, 0.752655, 0.7553, 0.757936, 0.760562, 0.763178, 0.765784, 0.76838, 0.770966, 0.773542, 0.776107, 0.778662, 0.781207, 0.783741, 0.786264, 0.788776, 0.791278, 0.793768, 0.796248, 0.798716, 0.801173, 0.803619, 0.806053, 0.808476, 0.810887, 0.813286, 0.815673, 0.818049, 0.820413, 0.822764, 0.825103, 0.82743, 0.829745, 0.832047, 0.834337, 0.836614, 0.838879, 0.84113, 0.843369, 0.845595, 0.847808, 0.850007, 0.852194, 0.854367, 0.856527, 0.858673, 0.860806, 0.862925, 0.86503, 0.867122, 0.8692, 0.871264, 0.873314, 0.87535, 0.877372, 0.879379, 0.881372, 0.883351, 0.885315, 0.887265, 0.8892, 0.891121, 0.893027, 0.894917, 0.896793, 0.898655, 0.900501, 0.902331, 0.904147, 0.905948, 0.907733, 0.909503, 0.911257, 0.912996, 0.914719, 0.916427, 0.918119, 0.919795, 0.921455, 0.923099, 0.924728, 0.92634, 0.927936, 0.929517, 0.931081, 0.932628, 0.93416, 0.935675, 0.937173, 0.938655, 0.940121, 0.94157, 0.943002, 0.944418, 0.945817, 0.947199, 0.948564, 0.949912, 0.951243, 0.952557, 0.953854, 0.955134, 0.956397, 0.957643, 0.958871, 0.960082, 0.961276, 0.962452, 0.963611, 0.964752, 0.965876, 0.966983, 0.968071, 0.969142, 0.970195, 0.971231, 0.972249, 0.973249, 0.974231, 0.975195, 0.976141, 0.97707, 0.97798, 0.978872, 0.979746, 0.980603, 0.981441, 0.98226, 0.983062, 0.983846, 0.984611, 0.985358, 0.986086, 0.986796, 0.987488, 0.988162, 0.988817, 0.989454, 0.990072, 0.990671, 0.991253, 0.991815, 0.992359, 0.992885, 0.993392, 0.99388, 0.99435, 0.994801, 0.995233, 0.995647, 0.996042, 0.996418, 0.996776, 0.997115, 0.997435, 0.997736, 0.998019, 0.998282, 0.998527, 0.998753, 0.998961, 0.999149, 0.999319, 0.99947, 0.999602, 0.999715, 0.999809, 0.999884, 0.999941, 0.999979, 0.999998, 0.999998, 0.999979, 0.999941, 0.999884, 0.999809, 0.999715, 0.999602, 0.99947, 0.999319, 0.999149, 0.998961, 0.998753, 0.998527, 0.998282, 0.998019, 0.997736, 0.997435, 0.997115, 0.996776, 0.996418, 0.996042, 0.995647, 0.995233, 0.994801, 0.99435, 0.99388, 0.993392, 0.992885, 0.992359, 0.991815, 0.991253, 0.990671, 0.990072, 0.989454, 0.988817, 0.988162, 0.987488, 0.986796, 0.986086, 0.985358, 0.984611, 0.983846, 0.983062, 0.98226, 0.981441, 0.980603, 0.979746, 0.978872, 0.97798, 0.97707, 0.976141, 0.975195, 0.974231, 0.973249, 0.972249, 0.971231, 0.970195, 0.969142, 0.968071, 0.966983, 0.965876, 0.964752, 0.963611, 0.962452, 0.961276, 0.960082, 0.958871, 0.957643, 0.956397, 0.955134, 0.953854, 0.952557, 0.951243, 0.949912, 0.948564, 0.947199, 0.945817, 0.944418, 0.943002, 0.94157, 0.940121, 0.938655, 0.937173, 0.935675, 0.93416, 0.932628, 0.931081, 0.929517, 0.927936, 0.92634, 0.924728, 0.923099, 0.921455, 0.919795, 0.918119, 0.916427, 0.914719, 0.912996, 0.911257, 0.909503, 0.907733, 0.905948, 0.904147, 0.902331, 0.900501, 0.898655, 0.896793, 0.894917, 0.893027, 0.891121, 0.8892, 0.887265, 0.885315, 0.883351, 0.881372, 0.879379, 0.877372, 0.87535, 0.873314, 0.871264, 0.8692, 0.867122, 0.86503, 0.862925, 0.860806, 0.858673, 0.856527, 0.854367, 0.852194, 0.850007, 0.847808, 0.845595, 0.843369, 0.84113, 0.838879, 0.836614, 0.834337, 0.832047, 0.829745, 0.82743, 0.825103, 0.822764, 0.820413, 0.818049, 0.815673, 0.813286, 0.810887, 0.808476, 0.806053, 0.803619, 0.801173, 0.798716, 0.796248, 0.793768, 0.791278, 0.788776, 0.786264, 0.783741, 0.781207, 0.778662, 0.776107, 0.773542, 0.770966, 0.76838, 0.765784, 0.763178, 0.760562, 0.757936, 0.7553, 0.752655, 0.75, 0.747336, 0.744662, 0.741979, 0.739287, 0.736587, 0.733877, 0.731158, 0.728431, 0.725695, 0.72295, 0.720197, 0.717436, 0.714666, 0.711889, 0.709103, 0.70631, 0.703509, 0.7007, 0.697883, 0.695059, 0.692228, 0.689389, 0.686544, 0.683691, 0.680831, 0.677965, 0.675092, 0.672212, 0.669326, 0.666433, 0.663534, 0.660629, 0.657718, 0.654801, 0.651878, 0.648949, 0.646015, 0.643075, 0.640129, 0.637179, 0.634223, 0.631263, 0.628297, 0.625326, 0.622351, 0.619371, 0.616387, 0.613398, 0.610405, 0.607408, 0.604406, 0.601401, 0.598392, 0.595379, 0.592363, 0.589343, 0.58632, 0.583294, 0.580264, 0.577231, 0.574196, 0.571157, 0.568116, 0.565073, 0.562027, 0.558978, 0.555928, 0.552875, 0.54982, 0.546764, 0.543705, 0.540645, 0.537584, 0.534521, 0.531457, 0.528391, 0.525325, 0.522257, 0.519189, 0.51612, 0.51305, 0.50998, 0.506909, 0.503839, 0.500768, 0.497697, 0.494626, 0.491555, 0.488485, 0.485415, 0.482346, 0.479277, 0.476209, 0.473142, 0.470076, 0.467011, 0.463948, 0.460885, 0.457824, 0.454765, 0.451708, 0.448652, 0.445598, 0.442547, 0.439497, 0.43645, 0.433405, 0.430363, 0.427323, 0.424286, 0.421252, 0.418221, 0.415193, 0.412168, 0.409146, 0.406128, 0.403114, 0.400103, 0.397096, 0.394092, 0.391093, 0.388098, 0.385107, 0.382121, 0.379138, 0.376161, 0.373188, 0.37022, 0.367256, 0.364298, 0.361345, 0.358397, 0.355455, 0.352518, 0.349586, 0.34666, 0.34374, 0.340826, 0.337918, 0.335016, 0.33212, 0.32923, 0.326347, 0.323471, 0.320601, 0.317738, 0.314882, 0.312033, 0.30919, 0.306355, 0.303528, 0.300708, 0.297895, 0.29509, 0.292293, 0.289503, 0.286721, 0.283948, 0.281183, 0.278425, 0.275677, 0.272936, 0.270205, 0.267482, 0.264767, 0.262062, 0.259365, 0.256678, 0.254, 0.251331, 0.248671, 0.246021, 0.243381, 0.24075, 0.238129, 0.235518, 0.232917, 0.230326, 0.227745, 0.225174, 0.222614, 0.220064, 0.217525, 0.214996, 0.212479, 0.209972, 0.207475, 0.20499, 0.202517, 0.200054, 0.197603, 0.195163, 0.192734, 0.190317, 0.187912, 0.185519, 0.183137, 0.180768, 0.17841, 0.176065, 0.173732, 0.171411, 0.169102, 0.166806, 0.164523, 0.162252, 0.159994, 0.157749, 0.155517, 0.153297, 0.151091, 0.148898, 0.146718, 0.144552, 0.142399, 0.140259, 0.138133, 0.136021, 0.133922, 0.131837, 0.129766, 0.127709, 0.125666, 0.123638, 0.121623, 0.119623, 0.117637, 0.115665, 0.113708, 0.111765, 0.109838, 0.107924, 0.106026, 0.104143, 0.102274, 0.100421, 0.0985821, 0.0967588, 0.0949507, 0.0931578, 0.0913804, 0.0896183, 0.0878717, 0.0861406, 0.0844252, 0.0827255, 0.0810414, 0.0793732, 0.0777209, 0.0760845, 0.0744641, 0.0728597, 0.0712714, 0.0696993, 0.0681435, 0.0666039, 0.0650807, 0.0635739, 0.0620836, 0.0606098, 0.0591525, 0.0577119, 0.056288, 0.0548808, 0.0534904, 0.0521168, 0.0507601, 0.0494204, 0.0480977, 0.046792, 0.0455035, 0.044232, 0.0429778, 0.0417408, 0.0405211, 0.0393187, 0.0381337, 0.0369661, 0.035816, 0.0346834, 0.0335684, 0.0324709, 0.0313911, 0.030329, 0.0292846, 0.0282579, 0.027249, 0.026258, 0.0252849, 0.0243296, 0.0233923, 0.022473, 0.0215716, 0.0206884, 0.0198232, 0.0189761, 0.0181472, 0.0173364, 0.0165439, 0.0157696, 0.0150135, 0.0142758, 0.0135564, 0.0128553, 0.0121726, 0.0115083, 0.0108624, 0.010235, 0.00962609, 0.00903565, 0.00846373, 0.00791035, 0.00737554, 0.00685931, 0.00636168, 0.00588268, 0.00542231, 0.0049806, 0.00455757, 0.00415322, 0.00376758, 0.00340066, 0.00305247, 0.00272303, 0.00241234, 0.00212043, 0.0018473, 0.00159296, 0.00135742, 0.00114069, 0.000942783, 0.0007637, 0.00060345, 0.000462038, 0.00033947, 0.000235751, 0.000150885, 8.48748e-005, 3.77227e-005, 9.43077e-006, 0 };

// Applies the hanning LUT to the supplied array of data
void applyHanningTable(float* data, int datasize);
////////////////// END HANNING LOOKUP TABLE

////////////////// BIT REVERSING LOOKUP TABLE

const int reversebit_lut_i[] = {0, 512, 256, 768, 128, 640, 384, 896, 64, 576, 320, 832, 192, 704, 448, 960, 32, 544, 288, 800, 160, 672, 416, 928, 96, 608, 352, 864, 224, 736, 480, 992, 16, 528, 272, 784, 144, 656, 400, 912, 80, 592, 336, 848, 208, 720, 464, 976, 48, 560, 304, 816, 176, 688, 432, 944, 112, 624, 368, 880, 240, 752, 496, 1008, 8, 520, 264, 776, 136, 648, 392, 904, 72, 584, 328, 840, 200, 712, 456, 968, 40, 552, 296, 808, 168, 680, 424, 936, 104, 616, 360, 872, 232, 744, 488, 1000, 24, 536, 280, 792, 152, 664, 408, 920, 88, 600, 344, 856, 216, 728, 472, 984, 56, 568, 312, 824, 184, 696, 440, 952, 120, 632, 376, 888, 248, 760, 504, 1016, 4, 516, 260, 772, 132, 644, 388, 900, 68, 580, 324, 836, 196, 708, 452, 964, 36, 548, 292, 804, 164, 676, 420, 932, 100, 612, 356, 868, 228, 740, 484, 996, 20, 532, 276, 788, 148, 660, 404, 916, 84, 596, 340, 852, 212, 724, 468, 980, 52, 564, 308, 820, 180, 692, 436, 948, 116, 628, 372, 884, 244, 756, 500, 1012, 12, 524, 268, 780, 140, 652, 396, 908, 76, 588, 332, 844, 204, 716, 460, 972, 44, 556, 300, 812, 172, 684, 428, 940, 108, 620, 364, 876, 236, 748, 492, 1004, 28, 540, 284, 796, 156, 668, 412, 924, 92, 604, 348, 860, 220, 732, 476, 988, 60, 572, 316, 828, 188, 700, 444, 956, 124, 636, 380, 892, 252, 764, 508, 1020, 2, 514, 258, 770, 130, 642, 386, 898, 66, 578, 322, 834, 194, 706, 450, 962, 34, 546, 290, 802, 162, 674, 418, 930, 98, 610, 354, 866, 226, 738, 482, 994, 18, 530, 274, 786, 146, 658, 402, 914, 82, 594, 338, 850, 210, 722, 466, 978, 50, 562, 306, 818, 178, 690, 434, 946, 114, 626, 370, 882, 242, 754, 498, 1010, 10, 522, 266, 778, 138, 650, 394, 906, 74, 586, 330, 842, 202, 714, 458, 970, 42, 554, 298, 810, 170, 682, 426, 938, 106, 618, 362, 874, 234, 746, 490, 1002, 26, 538, 282, 794, 154, 666, 410, 922, 90, 602, 346, 858, 218, 730, 474, 986, 58, 570, 314, 826, 186, 698, 442, 954, 122, 634, 378, 890, 250, 762, 506, 1018, 6, 518, 262, 774, 134, 646, 390, 902, 70, 582, 326, 838, 198, 710, 454, 966, 38, 550, 294, 806, 166, 678, 422, 934, 102, 614, 358, 870, 230, 742, 486, 998, 22, 534, 278, 790, 150, 662, 406, 918, 86, 598, 342, 854, 214, 726, 470, 982, 54, 566, 310, 822, 182, 694, 438, 950, 118, 630, 374, 886, 246, 758, 502, 1014, 14, 526, 270, 782, 142, 654, 398, 910, 78, 590, 334, 846, 206, 718, 462, 974, 46, 558, 302, 814, 174, 686, 430, 942, 110, 622, 366, 878, 238, 750, 494, 1006, 30, 542, 286, 798, 158, 670, 414, 926, 94, 606, 350, 862, 222, 734, 478, 990, 62, 574, 318, 830, 190, 702, 446, 958, 126, 638, 382, 894, 254, 766, 510, 1022, 1, 513, 257, 769, 129, 641, 385, 897, 65, 577, 321, 833, 193, 705, 449, 961, 33, 545, 289, 801, 161, 673, 417, 929, 97, 609, 353, 865, 225, 737, 481, 993, 17, 529, 273, 785, 145, 657, 401, 913, 81, 593, 337, 849, 209, 721, 465, 977, 49, 561, 305, 817, 177, 689, 433, 945, 113, 625, 369, 881, 241, 753, 497, 1009, 9, 521, 265, 777, 137, 649, 393, 905, 73, 585, 329, 841, 201, 713, 457, 969, 41, 553, 297, 809, 169, 681, 425, 937, 105, 617, 361, 873, 233, 745, 489, 1001, 25, 537, 281, 793, 153, 665, 409, 921, 89, 601, 345, 857, 217, 729, 473, 985, 57, 569, 313, 825, 185, 697, 441, 953, 121, 633, 377, 889, 249, 761, 505, 1017, 5, 517, 261, 773, 133, 645, 389, 901, 69, 581, 325, 837, 197, 709, 453, 965, 37, 549, 293, 805, 165, 677, 421, 933, 101, 613, 357, 869, 229, 741, 485, 997, 21, 533, 277, 789, 149, 661, 405, 917, 85, 597, 341, 853, 213, 725, 469, 981, 53, 565, 309, 821, 181, 693, 437, 949, 117, 629, 373, 885, 245, 757, 501, 1013, 13, 525, 269, 781, 141, 653, 397, 909, 77, 589, 333, 845, 205, 717, 461, 973, 45, 557, 301, 813, 173, 685, 429, 941, 109, 621, 365, 877, 237, 749, 493, 1005, 29, 541, 285, 797, 157, 669, 413, 925, 93, 605, 349, 861, 221, 733, 477, 989, 61, 573, 317, 829, 189, 701, 445, 957, 125, 637, 381, 893, 253, 765, 509, 1021, 3, 515, 259, 771, 131, 643, 387, 899, 67, 579, 323, 835, 195, 707, 451, 963, 35, 547, 291, 803, 163, 675, 419, 931, 99, 611, 355, 867, 227, 739, 483, 995, 19, 531, 275, 787, 147, 659, 403, 915, 83, 595, 339, 851, 211, 723, 467, 979, 51, 563, 307, 819, 179, 691, 435, 947, 115, 627, 371, 883, 243, 755, 499, 1011, 11, 523, 267, 779, 139, 651, 395, 907, 75, 587, 331, 843, 203, 715, 459, 971, 43, 555, 299, 811, 171, 683, 427, 939, 107, 619, 363, 875, 235, 747, 491, 1003, 27, 539, 283, 795, 155, 667, 411, 923, 91, 603, 347, 859, 219, 731, 475, 987, 59, 571, 315, 827, 187, 699, 443, 955, 123, 635, 379, 891, 251, 763, 507, 1019, 7, 519, 263, 775, 135, 647, 391, 903, 71, 583, 327, 839, 199, 711, 455, 967, 39, 551, 295, 807, 167, 679, 423, 935, 103, 615, 359, 871, 231, 743, 487, 999, 23, 535, 279, 791, 151, 663, 407, 919, 87, 599, 343, 855, 215, 727, 471, 983, 55, 567, 311, 823, 183, 695, 439, 951, 119, 631, 375, 887, 247, 759, 503, 1015, 15, 527, 271, 783, 143, 655, 399, 911, 79, 591, 335, 847, 207, 719, 463, 975, 47, 559, 303, 815, 175, 687, 431, 943, 111, 623, 367, 879, 239, 751, 495, 1007, 31, 543, 287, 799, 159, 671, 415, 927, 95, 607, 351, 863, 223, 735, 479, 991, 63, 575, 319, 831, 191, 703, 447, 959, 127, 639, 383, 895, 255, 767, 511, 1023};

////////////////// END BIT REVERSING LOOKUP TABLE

////////////////// TWIDDLEFACTOR LOOKUP TABLE

// Twiddle factors are complex, thus two look up tables, one for the real and one for the imaginary part
const float twiddleLookupTable_Real[] = { 1, 0.999981, 0.999925, 0.999831, 0.999699, 0.999529, 0.999322, 0.999078, 0.998795, 0.998476, 0.998118, 0.997723, 0.99729, 0.99682, 0.996313, 0.995767, 0.995185, 0.994565, 0.993907, 0.993212, 0.99248, 0.99171, 0.990903, 0.990058, 0.989177, 0.988258, 0.987301, 0.986308, 0.985278, 0.98421, 0.983105, 0.981964, 0.980785, 0.97957, 0.978317, 0.977028, 0.975702, 0.974339, 0.97294, 0.971504, 0.970031, 0.968522, 0.966976, 0.965394, 0.963776, 0.962121, 0.960431, 0.958703, 0.95694, 0.955141, 0.953306, 0.951435, 0.949528, 0.947586, 0.945607, 0.943593, 0.941544, 0.939459, 0.937339, 0.935184, 0.932993, 0.930767, 0.928506, 0.92621, 0.92388, 0.921514, 0.919114, 0.916679, 0.91421, 0.911706, 0.909168, 0.906596, 0.903989, 0.901349, 0.898674, 0.895966, 0.893224, 0.890449, 0.88764, 0.884797, 0.881921, 0.879012, 0.87607, 0.873095, 0.870087, 0.867046, 0.863973, 0.860867, 0.857729, 0.854558, 0.851355, 0.84812, 0.844854, 0.841555, 0.838225, 0.834863, 0.83147, 0.828045, 0.824589, 0.821102, 0.817585, 0.814036, 0.810457, 0.806848, 0.803208, 0.799537, 0.795837, 0.792107, 0.788346, 0.784557, 0.780737, 0.776888, 0.77301, 0.769103, 0.765167, 0.761202, 0.757209, 0.753187, 0.749136, 0.745058, 0.740951, 0.736817, 0.732654, 0.728464, 0.724247, 0.720003, 0.715731, 0.711432, 0.707107, 0.702755, 0.698376, 0.693971, 0.689541, 0.685084, 0.680601, 0.676093, 0.671559, 0.667, 0.662416, 0.657807, 0.653173, 0.648514, 0.643832, 0.639124, 0.634393, 0.629638, 0.62486, 0.620057, 0.615232, 0.610383, 0.605511, 0.600616, 0.595699, 0.59076, 0.585798, 0.580814, 0.575808, 0.570781, 0.565732, 0.560662, 0.55557, 0.550458, 0.545325, 0.540171, 0.534998, 0.529804, 0.52459, 0.519356, 0.514103, 0.50883, 0.503538, 0.498228, 0.492898, 0.48755, 0.482184, 0.476799, 0.471397, 0.465977, 0.460539, 0.455084, 0.449611, 0.444122, 0.438616, 0.433094, 0.427555, 0.422, 0.41643, 0.410843, 0.405241, 0.399624, 0.393992, 0.388345, 0.382683, 0.377007, 0.371317, 0.365613, 0.359895, 0.354164, 0.348419, 0.342661, 0.33689, 0.331106, 0.32531, 0.319502, 0.313682, 0.30785, 0.302006, 0.296151, 0.290285, 0.284408, 0.27852, 0.272621, 0.266713, 0.260794, 0.254866, 0.248928, 0.24298, 0.237024, 0.231058, 0.225084, 0.219101, 0.21311, 0.207111, 0.201105, 0.19509, 0.189069, 0.18304, 0.177004, 0.170962, 0.164913, 0.158858, 0.152797, 0.14673, 0.140658, 0.134581, 0.128498, 0.122411, 0.116319, 0.110222, 0.104122, 0.0980171, 0.091909, 0.0857973, 0.0796824, 0.0735646, 0.0674439, 0.0613207, 0.0551952, 0.0490677, 0.0429383, 0.0368072, 0.0306748, 0.0245412, 0.0184067, 0.0122715, 0.00613588, 6.12323e-017, -0.00613588, -0.0122715, -0.0184067, -0.0245412, -0.0306748, -0.0368072, -0.0429383, -0.0490677, -0.0551952, -0.0613207, -0.0674439, -0.0735646, -0.0796824, -0.0857973, -0.091909, -0.0980171, -0.104122, -0.110222, -0.116319, -0.122411, -0.128498, -0.134581, -0.140658, -0.14673, -0.152797, -0.158858, -0.164913, -0.170962, -0.177004, -0.18304, -0.189069, -0.19509, -0.201105, -0.207111, -0.21311, -0.219101, -0.225084, -0.231058, -0.237024, -0.24298, -0.248928, -0.254866, -0.260794, -0.266713, -0.272621, -0.27852, -0.284408, -0.290285, -0.296151, -0.302006, -0.30785, -0.313682, -0.319502, -0.32531, -0.331106, -0.33689, -0.342661, -0.348419, -0.354164, -0.359895, -0.365613, -0.371317, -0.377007, -0.382683, -0.388345, -0.393992, -0.399624, -0.405241, -0.410843, -0.41643, -0.422, -0.427555, -0.433094, -0.438616, -0.444122, -0.449611, -0.455084, -0.460539, -0.465977, -0.471397, -0.476799, -0.482184, -0.48755, -0.492898, -0.498228, -0.503538, -0.50883, -0.514103, -0.519356, -0.52459, -0.529804, -0.534998, -0.540171, -0.545325, -0.550458, -0.55557, -0.560662, -0.565732, -0.570781, -0.575808, -0.580814, -0.585798, -0.59076, -0.595699, -0.600616, -0.605511, -0.610383, -0.615232, -0.620057, -0.62486, -0.629638, -0.634393, -0.639124, -0.643832, -0.648514, -0.653173, -0.657807, -0.662416, -0.667, -0.671559, -0.676093, -0.680601, -0.685084, -0.689541, -0.693971, -0.698376, -0.702755, -0.707107, -0.711432, -0.715731, -0.720003, -0.724247, -0.728464, -0.732654, -0.736817, -0.740951, -0.745058, -0.749136, -0.753187, -0.757209, -0.761202, -0.765167, -0.769103, -0.77301, -0.776888, -0.780737, -0.784557, -0.788346, -0.792107, -0.795837, -0.799537, -0.803208, -0.806848, -0.810457, -0.814036, -0.817585, -0.821102, -0.824589, -0.828045, -0.83147, -0.834863, -0.838225, -0.841555, -0.844854, -0.84812, -0.851355, -0.854558, -0.857729, -0.860867, -0.863973, -0.867046, -0.870087, -0.873095, -0.87607, -0.879012, -0.881921, -0.884797, -0.88764, -0.890449, -0.893224, -0.895966, -0.898674, -0.901349, -0.903989, -0.906596, -0.909168, -0.911706, -0.91421, -0.916679, -0.919114, -0.921514, -0.92388, -0.92621, -0.928506, -0.930767, -0.932993, -0.935184, -0.937339, -0.939459, -0.941544, -0.943593, -0.945607, -0.947586, -0.949528, -0.951435, -0.953306, -0.955141, -0.95694, -0.958703, -0.960431, -0.962121, -0.963776, -0.965394, -0.966976, -0.968522, -0.970031, -0.971504, -0.97294, -0.974339, -0.975702, -0.977028, -0.978317, -0.97957, -0.980785, -0.981964, -0.983105, -0.98421, -0.985278, -0.986308, -0.987301, -0.988258, -0.989177, -0.990058, -0.990903, -0.99171, -0.99248, -0.993212, -0.993907, -0.994565, -0.995185, -0.995767, -0.996313, -0.99682, -0.99729, -0.997723, -0.998118, -0.998476, -0.998795, -0.999078, -0.999322, -0.999529, -0.999699, -0.999831, -0.999925, -0.999981, -1, -0.999981, -0.999925, -0.999831, -0.999699, -0.999529, -0.999322, -0.999078, -0.998795, -0.998476, -0.998118, -0.997723, -0.99729, -0.99682, -0.996313, -0.995767, -0.995185, -0.994565, -0.993907, -0.993212, -0.99248, -0.99171, -0.990903, -0.990058, -0.989177, -0.988258, -0.987301, -0.986308, -0.985278, -0.98421, -0.983105, -0.981964, -0.980785, -0.97957, -0.978317, -0.977028, -0.975702, -0.974339, -0.97294, -0.971504, -0.970031, -0.968522, -0.966976, -0.965394, -0.963776, -0.962121, -0.960431, -0.958703, -0.95694, -0.955141, -0.953306, -0.951435, -0.949528, -0.947586, -0.945607, -0.943593, -0.941544, -0.939459, -0.937339, -0.935184, -0.932993, -0.930767, -0.928506, -0.92621, -0.92388, -0.921514, -0.919114, -0.916679, -0.91421, -0.911706, -0.909168, -0.906596, -0.903989, -0.901349, -0.898674, -0.895966, -0.893224, -0.890449, -0.88764, -0.884797, -0.881921, -0.879012, -0.87607, -0.873095, -0.870087, -0.867046, -0.863973, -0.860867, -0.857729, -0.854558, -0.851355, -0.84812, -0.844854, -0.841555, -0.838225, -0.834863, -0.83147, -0.828045, -0.824589, -0.821102, -0.817585, -0.814036, -0.810457, -0.806848, -0.803208, -0.799537, -0.795837, -0.792107, -0.788346, -0.784557, -0.780737, -0.776888, -0.77301, -0.769103, -0.765167, -0.761202, -0.757209, -0.753187, -0.749136, -0.745058, -0.740951, -0.736817, -0.732654, -0.728464, -0.724247, -0.720003, -0.715731, -0.711432, -0.707107, -0.702755, -0.698376, -0.693971, -0.689541, -0.685084, -0.680601, -0.676093, -0.671559, -0.667, -0.662416, -0.657807, -0.653173, -0.648514, -0.643832, -0.639124, -0.634393, -0.629638, -0.62486, -0.620057, -0.615232, -0.610383, -0.605511, -0.600616, -0.595699, -0.59076, -0.585798, -0.580814, -0.575808, -0.570781, -0.565732, -0.560662, -0.55557, -0.550458, -0.545325, -0.540171, -0.534998, -0.529804, -0.52459, -0.519356, -0.514103, -0.50883, -0.503538, -0.498228, -0.492898, -0.48755, -0.482184, -0.476799, -0.471397, -0.465977, -0.460539, -0.455084, -0.449611, -0.444122, -0.438616, -0.433094, -0.427555, -0.422, -0.41643, -0.410843, -0.405241, -0.399624, -0.393992, -0.388345, -0.382683, -0.377007, -0.371317, -0.365613, -0.359895, -0.354164, -0.348419, -0.342661, -0.33689, -0.331106, -0.32531, -0.319502, -0.313682, -0.30785, -0.302006, -0.296151, -0.290285, -0.284408, -0.27852, -0.272621, -0.266713, -0.260794, -0.254866, -0.248928, -0.24298, -0.237024, -0.231058, -0.225084, -0.219101, -0.21311, -0.207111, -0.201105, -0.19509, -0.189069, -0.18304, -0.177004, -0.170962, -0.164913, -0.158858, -0.152797, -0.14673, -0.140658, -0.134581, -0.128498, -0.122411, -0.116319, -0.110222, -0.104122, -0.0980171, -0.091909, -0.0857973, -0.0796824, -0.0735646, -0.0674439, -0.0613207, -0.0551952, -0.0490677, -0.0429383, -0.0368072, -0.0306748, -0.0245412, -0.0184067, -0.0122715, -0.00613588, -1.83697e-016, 0.00613588, 0.0122715, 0.0184067, 0.0245412, 0.0306748, 0.0368072, 0.0429383, 0.0490677, 0.0551952, 0.0613207, 0.0674439, 0.0735646, 0.0796824, 0.0857973, 0.091909, 0.0980171, 0.104122, 0.110222, 0.116319, 0.122411, 0.128498, 0.134581, 0.140658, 0.14673, 0.152797, 0.158858, 0.164913, 0.170962, 0.177004, 0.18304, 0.189069, 0.19509, 0.201105, 0.207111, 0.21311, 0.219101, 0.225084, 0.231058, 0.237024, 0.24298, 0.248928, 0.254866, 0.260794, 0.266713, 0.272621, 0.27852, 0.284408, 0.290285, 0.296151, 0.302006, 0.30785, 0.313682, 0.319502, 0.32531, 0.331106, 0.33689, 0.342661, 0.348419, 0.354164, 0.359895, 0.365613, 0.371317, 0.377007, 0.382683, 0.388345, 0.393992, 0.399624, 0.405241, 0.410843, 0.41643, 0.422, 0.427555, 0.433094, 0.438616, 0.444122, 0.449611, 0.455084, 0.460539, 0.465977, 0.471397, 0.476799, 0.482184, 0.48755, 0.492898, 0.498228, 0.503538, 0.50883, 0.514103, 0.519356, 0.52459, 0.529804, 0.534998, 0.540171, 0.545325, 0.550458, 0.55557, 0.560662, 0.565732, 0.570781, 0.575808, 0.580814, 0.585798, 0.59076, 0.595699, 0.600616, 0.605511, 0.610383, 0.615232, 0.620057, 0.62486, 0.629638, 0.634393, 0.639124, 0.643832, 0.648514, 0.653173, 0.657807, 0.662416, 0.667, 0.671559, 0.676093, 0.680601, 0.685084, 0.689541, 0.693971, 0.698376, 0.702755, 0.707107, 0.711432, 0.715731, 0.720003, 0.724247, 0.728464, 0.732654, 0.736817, 0.740951, 0.745058, 0.749136, 0.753187, 0.757209, 0.761202, 0.765167, 0.769103, 0.77301, 0.776888, 0.780737, 0.784557, 0.788346, 0.792107, 0.795837, 0.799537, 0.803208, 0.806848, 0.810457, 0.814036, 0.817585, 0.821102, 0.824589, 0.828045, 0.83147, 0.834863, 0.838225, 0.841555, 0.844854, 0.84812, 0.851355, 0.854558, 0.857729, 0.860867, 0.863973, 0.867046, 0.870087, 0.873095, 0.87607, 0.879012, 0.881921, 0.884797, 0.88764, 0.890449, 0.893224, 0.895966, 0.898674, 0.901349, 0.903989, 0.906596, 0.909168, 0.911706, 0.91421, 0.916679, 0.919114, 0.921514, 0.92388, 0.92621, 0.928506, 0.930767, 0.932993, 0.935184, 0.937339, 0.939459, 0.941544, 0.943593, 0.945607, 0.947586, 0.949528, 0.951435, 0.953306, 0.955141, 0.95694, 0.958703, 0.960431, 0.962121, 0.963776, 0.965394, 0.966976, 0.968522, 0.970031, 0.971504, 0.97294, 0.974339, 0.975702, 0.977028, 0.978317, 0.97957, 0.980785, 0.981964, 0.983105, 0.98421, 0.985278, 0.986308, 0.987301, 0.988258, 0.989177, 0.990058, 0.990903, 0.99171, 0.99248, 0.993212, 0.993907, 0.994565, 0.995185, 0.995767, 0.996313, 0.99682, 0.99729, 0.997723, 0.998118, 0.998476, 0.998795, 0.999078, 0.999322, 0.999529, 0.999699, 0.999831, 0.999925, 0.999981};
const float twiddleLookupTable_Imaginary[] = { 0, -0.00613588, -0.0122715, -0.0184067, -0.0245412, -0.0306748, -0.0368072, -0.0429383, -0.0490677, -0.0551952, -0.0613207, -0.0674439, -0.0735646, -0.0796824, -0.0857973, -0.091909, -0.0980171, -0.104122, -0.110222, -0.116319, -0.122411, -0.128498, -0.134581, -0.140658, -0.14673, -0.152797, -0.158858, -0.164913, -0.170962, -0.177004, -0.18304, -0.189069, -0.19509, -0.201105, -0.207111, -0.21311, -0.219101, -0.225084, -0.231058, -0.237024, -0.24298, -0.248928, -0.254866, -0.260794, -0.266713, -0.272621, -0.27852, -0.284408, -0.290285, -0.296151, -0.302006, -0.30785, -0.313682, -0.319502, -0.32531, -0.331106, -0.33689, -0.342661, -0.348419, -0.354164, -0.359895, -0.365613, -0.371317, -0.377007, -0.382683, -0.388345, -0.393992, -0.399624, -0.405241, -0.410843, -0.41643, -0.422, -0.427555, -0.433094, -0.438616, -0.444122, -0.449611, -0.455084, -0.460539, -0.465977, -0.471397, -0.476799, -0.482184, -0.48755, -0.492898, -0.498228, -0.503538, -0.50883, -0.514103, -0.519356, -0.52459, -0.529804, -0.534998, -0.540171, -0.545325, -0.550458, -0.55557, -0.560662, -0.565732, -0.570781, -0.575808, -0.580814, -0.585798, -0.59076, -0.595699, -0.600616, -0.605511, -0.610383, -0.615232, -0.620057, -0.62486, -0.629638, -0.634393, -0.639124, -0.643832, -0.648514, -0.653173, -0.657807, -0.662416, -0.667, -0.671559, -0.676093, -0.680601, -0.685084, -0.689541, -0.693971, -0.698376, -0.702755, -0.707107, -0.711432, -0.715731, -0.720003, -0.724247, -0.728464, -0.732654, -0.736817, -0.740951, -0.745058, -0.749136, -0.753187, -0.757209, -0.761202, -0.765167, -0.769103, -0.77301, -0.776888, -0.780737, -0.784557, -0.788346, -0.792107, -0.795837, -0.799537, -0.803208, -0.806848, -0.810457, -0.814036, -0.817585, -0.821102, -0.824589, -0.828045, -0.83147, -0.834863, -0.838225, -0.841555, -0.844854, -0.84812, -0.851355, -0.854558, -0.857729, -0.860867, -0.863973, -0.867046, -0.870087, -0.873095, -0.87607, -0.879012, -0.881921, -0.884797, -0.88764, -0.890449, -0.893224, -0.895966, -0.898674, -0.901349, -0.903989, -0.906596, -0.909168, -0.911706, -0.91421, -0.916679, -0.919114, -0.921514, -0.92388, -0.92621, -0.928506, -0.930767, -0.932993, -0.935184, -0.937339, -0.939459, -0.941544, -0.943593, -0.945607, -0.947586, -0.949528, -0.951435, -0.953306, -0.955141, -0.95694, -0.958703, -0.960431, -0.962121, -0.963776, -0.965394, -0.966976, -0.968522, -0.970031, -0.971504, -0.97294, -0.974339, -0.975702, -0.977028, -0.978317, -0.97957, -0.980785, -0.981964, -0.983105, -0.98421, -0.985278, -0.986308, -0.987301, -0.988258, -0.989177, -0.990058, -0.990903, -0.99171, -0.99248, -0.993212, -0.993907, -0.994565, -0.995185, -0.995767, -0.996313, -0.99682, -0.99729, -0.997723, -0.998118, -0.998476, -0.998795, -0.999078, -0.999322, -0.999529, -0.999699, -0.999831, -0.999925, -0.999981, -1, -0.999981, -0.999925, -0.999831, -0.999699, -0.999529, -0.999322, -0.999078, -0.998795, -0.998476, -0.998118, -0.997723, -0.99729, -0.99682, -0.996313, -0.995767, -0.995185, -0.994565, -0.993907, -0.993212, -0.99248, -0.99171, -0.990903, -0.990058, -0.989177, -0.988258, -0.987301, -0.986308, -0.985278, -0.98421, -0.983105, -0.981964, -0.980785, -0.97957, -0.978317, -0.977028, -0.975702, -0.974339, -0.97294, -0.971504, -0.970031, -0.968522, -0.966976, -0.965394, -0.963776, -0.962121, -0.960431, -0.958703, -0.95694, -0.955141, -0.953306, -0.951435, -0.949528, -0.947586, -0.945607, -0.943593, -0.941544, -0.939459, -0.937339, -0.935184, -0.932993, -0.930767, -0.928506, -0.92621, -0.92388, -0.921514, -0.919114, -0.916679, -0.91421, -0.911706, -0.909168, -0.906596, -0.903989, -0.901349, -0.898674, -0.895966, -0.893224, -0.890449, -0.88764, -0.884797, -0.881921, -0.879012, -0.87607, -0.873095, -0.870087, -0.867046, -0.863973, -0.860867, -0.857729, -0.854558, -0.851355, -0.84812, -0.844854, -0.841555, -0.838225, -0.834863, -0.83147, -0.828045, -0.824589, -0.821102, -0.817585, -0.814036, -0.810457, -0.806848, -0.803208, -0.799537, -0.795837, -0.792107, -0.788346, -0.784557, -0.780737, -0.776888, -0.77301, -0.769103, -0.765167, -0.761202, -0.757209, -0.753187, -0.749136, -0.745058, -0.740951, -0.736817, -0.732654, -0.728464, -0.724247, -0.720003, -0.715731, -0.711432, -0.707107, -0.702755, -0.698376, -0.693971, -0.689541, -0.685084, -0.680601, -0.676093, -0.671559, -0.667, -0.662416, -0.657807, -0.653173, -0.648514, -0.643832, -0.639124, -0.634393, -0.629638, -0.62486, -0.620057, -0.615232, -0.610383, -0.605511, -0.600616, -0.595699, -0.59076, -0.585798, -0.580814, -0.575808, -0.570781, -0.565732, -0.560662, -0.55557, -0.550458, -0.545325, -0.540171, -0.534998, -0.529804, -0.52459, -0.519356, -0.514103, -0.50883, -0.503538, -0.498228, -0.492898, -0.48755, -0.482184, -0.476799, -0.471397, -0.465977, -0.460539, -0.455084, -0.449611, -0.444122, -0.438616, -0.433094, -0.427555, -0.422, -0.41643, -0.410843, -0.405241, -0.399624, -0.393992, -0.388345, -0.382683, -0.377007, -0.371317, -0.365613, -0.359895, -0.354164, -0.348419, -0.342661, -0.33689, -0.331106, -0.32531, -0.319502, -0.313682, -0.30785, -0.302006, -0.296151, -0.290285, -0.284408, -0.27852, -0.272621, -0.266713, -0.260794, -0.254866, -0.248928, -0.24298, -0.237024, -0.231058, -0.225084, -0.219101, -0.21311, -0.207111, -0.201105, -0.19509, -0.189069, -0.18304, -0.177004, -0.170962, -0.164913, -0.158858, -0.152797, -0.14673, -0.140658, -0.134581, -0.128498, -0.122411, -0.116319, -0.110222, -0.104122, -0.0980171, -0.091909, -0.0857973, -0.0796824, -0.0735646, -0.0674439, -0.0613207, -0.0551952, -0.0490677, -0.0429383, -0.0368072, -0.0306748, -0.0245412, -0.0184067, -0.0122715, -0.00613588, -1.22465e-016, 0.00613588, 0.0122715, 0.0184067, 0.0245412, 0.0306748, 0.0368072, 0.0429383, 0.0490677, 0.0551952, 0.0613207, 0.0674439, 0.0735646, 0.0796824, 0.0857973, 0.091909, 0.0980171, 0.104122, 0.110222, 0.116319, 0.122411, 0.128498, 0.134581, 0.140658, 0.14673, 0.152797, 0.158858, 0.164913, 0.170962, 0.177004, 0.18304, 0.189069, 0.19509, 0.201105, 0.207111, 0.21311, 0.219101, 0.225084, 0.231058, 0.237024, 0.24298, 0.248928, 0.254866, 0.260794, 0.266713, 0.272621, 0.27852, 0.284408, 0.290285, 0.296151, 0.302006, 0.30785, 0.313682, 0.319502, 0.32531, 0.331106, 0.33689, 0.342661, 0.348419, 0.354164, 0.359895, 0.365613, 0.371317, 0.377007, 0.382683, 0.388345, 0.393992, 0.399624, 0.405241, 0.410843, 0.41643, 0.422, 0.427555, 0.433094, 0.438616, 0.444122, 0.449611, 0.455084, 0.460539, 0.465977, 0.471397, 0.476799, 0.482184, 0.48755, 0.492898, 0.498228, 0.503538, 0.50883, 0.514103, 0.519356, 0.52459, 0.529804, 0.534998, 0.540171, 0.545325, 0.550458, 0.55557, 0.560662, 0.565732, 0.570781, 0.575808, 0.580814, 0.585798, 0.59076, 0.595699, 0.600616, 0.605511, 0.610383, 0.615232, 0.620057, 0.62486, 0.629638, 0.634393, 0.639124, 0.643832, 0.648514, 0.653173, 0.657807, 0.662416, 0.667, 0.671559, 0.676093, 0.680601, 0.685084, 0.689541, 0.693971, 0.698376, 0.702755, 0.707107, 0.711432, 0.715731, 0.720003, 0.724247, 0.728464, 0.732654, 0.736817, 0.740951, 0.745058, 0.749136, 0.753187, 0.757209, 0.761202, 0.765167, 0.769103, 0.77301, 0.776888, 0.780737, 0.784557, 0.788346, 0.792107, 0.795837, 0.799537, 0.803208, 0.806848, 0.810457, 0.814036, 0.817585, 0.821102, 0.824589, 0.828045, 0.83147, 0.834863, 0.838225, 0.841555, 0.844854, 0.84812, 0.851355, 0.854558, 0.857729, 0.860867, 0.863973, 0.867046, 0.870087, 0.873095, 0.87607, 0.879012, 0.881921, 0.884797, 0.88764, 0.890449, 0.893224, 0.895966, 0.898674, 0.901349, 0.903989, 0.906596, 0.909168, 0.911706, 0.91421, 0.916679, 0.919114, 0.921514, 0.92388, 0.92621, 0.928506, 0.930767, 0.932993, 0.935184, 0.937339, 0.939459, 0.941544, 0.943593, 0.945607, 0.947586, 0.949528, 0.951435, 0.953306, 0.955141, 0.95694, 0.958703, 0.960431, 0.962121, 0.963776, 0.965394, 0.966976, 0.968522, 0.970031, 0.971504, 0.97294, 0.974339, 0.975702, 0.977028, 0.978317, 0.97957, 0.980785, 0.981964, 0.983105, 0.98421, 0.985278, 0.986308, 0.987301, 0.988258, 0.989177, 0.990058, 0.990903, 0.99171, 0.99248, 0.993212, 0.993907, 0.994565, 0.995185, 0.995767, 0.996313, 0.99682, 0.99729, 0.997723, 0.998118, 0.998476, 0.998795, 0.999078, 0.999322, 0.999529, 0.999699, 0.999831, 0.999925, 0.999981, 1, 0.999981, 0.999925, 0.999831, 0.999699, 0.999529, 0.999322, 0.999078, 0.998795, 0.998476, 0.998118, 0.997723, 0.99729, 0.99682, 0.996313, 0.995767, 0.995185, 0.994565, 0.993907, 0.993212, 0.99248, 0.99171, 0.990903, 0.990058, 0.989177, 0.988258, 0.987301, 0.986308, 0.985278, 0.98421, 0.983105, 0.981964, 0.980785, 0.97957, 0.978317, 0.977028, 0.975702, 0.974339, 0.97294, 0.971504, 0.970031, 0.968522, 0.966976, 0.965394, 0.963776, 0.962121, 0.960431, 0.958703, 0.95694, 0.955141, 0.953306, 0.951435, 0.949528, 0.947586, 0.945607, 0.943593, 0.941544, 0.939459, 0.937339, 0.935184, 0.932993, 0.930767, 0.928506, 0.92621, 0.92388, 0.921514, 0.919114, 0.916679, 0.91421, 0.911706, 0.909168, 0.906596, 0.903989, 0.901349, 0.898674, 0.895966, 0.893224, 0.890449, 0.88764, 0.884797, 0.881921, 0.879012, 0.87607, 0.873095, 0.870087, 0.867046, 0.863973, 0.860867, 0.857729, 0.854558, 0.851355, 0.84812, 0.844854, 0.841555, 0.838225, 0.834863, 0.83147, 0.828045, 0.824589, 0.821102, 0.817585, 0.814036, 0.810457, 0.806848, 0.803208, 0.799537, 0.795837, 0.792107, 0.788346, 0.784557, 0.780737, 0.776888, 0.77301, 0.769103, 0.765167, 0.761202, 0.757209, 0.753187, 0.749136, 0.745058, 0.740951, 0.736817, 0.732654, 0.728464, 0.724247, 0.720003, 0.715731, 0.711432, 0.707107, 0.702755, 0.698376, 0.693971, 0.689541, 0.685084, 0.680601, 0.676093, 0.671559, 0.667, 0.662416, 0.657807, 0.653173, 0.648514, 0.643832, 0.639124, 0.634393, 0.629638, 0.62486, 0.620057, 0.615232, 0.610383, 0.605511, 0.600616, 0.595699, 0.59076, 0.585798, 0.580814, 0.575808, 0.570781, 0.565732, 0.560662, 0.55557, 0.550458, 0.545325, 0.540171, 0.534998, 0.529804, 0.52459, 0.519356, 0.514103, 0.50883, 0.503538, 0.498228, 0.492898, 0.48755, 0.482184, 0.476799, 0.471397, 0.465977, 0.460539, 0.455084, 0.449611, 0.444122, 0.438616, 0.433094, 0.427555, 0.422, 0.41643, 0.410843, 0.405241, 0.399624, 0.393992, 0.388345, 0.382683, 0.377007, 0.371317, 0.365613, 0.359895, 0.354164, 0.348419, 0.342661, 0.33689, 0.331106, 0.32531, 0.319502, 0.313682, 0.30785, 0.302006, 0.296151, 0.290285, 0.284408, 0.27852, 0.272621, 0.266713, 0.260794, 0.254866, 0.248928, 0.24298, 0.237024, 0.231058, 0.225084, 0.219101, 0.21311, 0.207111, 0.201105, 0.19509, 0.189069, 0.18304, 0.177004, 0.170962, 0.164913, 0.158858, 0.152797, 0.14673, 0.140658, 0.134581, 0.128498, 0.122411, 0.116319, 0.110222, 0.104122, 0.0980171, 0.091909, 0.0857973, 0.0796824, 0.0735646, 0.0674439, 0.0613207, 0.0551952, 0.0490677, 0.0429383, 0.0368072, 0.0306748, 0.0245412, 0.0184067, 0.0122715, 0.00613588};

////////////////// END TWIDDLEFACTOR LOOKUP TABLE

#endif