#include "mbed.h"
#include "DFT.h"
#include "LookupTables.h"
#include "complexmath.h"
#include <math.h>


AnalogIn emg1(A0);
Serial pc(USBTX, USBRX);
AnalogIn emg2(A1);
AnalogIn emg3(A2);
AnalogIn emg4(A3);
Ticker  ADCTimer;
bool fftflag = false;
int counter;
int PSDmag1;
int PSDmag2;
int PSDmag3;
int PSDmag4;
float sampleddataemg1[1024];
float sampleddataemg2[1024];
float sampleddataemg3[1024];
float sampleddataemg4[1024];


void sampling()
{
    while (fftflag == false) {
        sampleddataemg1[counter] = emg1;
        sampleddataemg2[counter] = emg2;
        sampleddataemg3[counter] = emg3;
        sampleddataemg4[counter] = emg4;
        counter++;
        if (counter >= 1024) {
            counter =0;
            pc.printf ("EMG data from A0 :[");
            for (int i=0; i<1024; i++) 
                pc.printf ("%f,\t",sampleddataemg1[i]);
            //pc.printf ("EMG data from A3 :[");
            //for (int i=0; i<1024; i++) 
            //    pc.printf ("%f,\t",sampleddataemg4[i]);
            fftflag = true;
            performFFT(sampleddataemg1, 1024);
            //pc.printf ("done 1");
            performFFT(sampleddataemg2, 1024);
            //pc.printf ("done 2");
            performFFT(sampleddataemg3, 1024);
            //pc.printf ("done 3");
            performFFT(sampleddataemg4, 1024);
            pc.printf ("\r\n\r\n\r\n post data from A0 :[");
            for (int i=0; i<1024; i++) 
                pc.printf ("%f,\t",sampleddataemg1[i]);
            //pc.printf ("post data from A3 :[");
            //for (int i=0; i<1024; i++) 
            //    pc.printf ("%f,\t",sampleddataemg4[i]);
            //pc.printf ("EMG data from A1 :[");
            //for (int i=0; i<1024; i++) 
            //    pc.printf ("%f,\t",sampleddataemg2[i]);
            //pc.printf ("EMG data from A2 :[");
            //for (int i=0; i<1024; i++) 
            //    pc.printf ("%f,\t",sampleddataemg3[i]);
            //pc.printf ("EMG data from A3 :[");
            //for (int i=0; i<1024; i++) 
            //    pc.printf ("%f,\t",sampleddataemg4[i]);   
             PSDmag1 = calcPSD(sampleddataemg1, 512);
             pc.printf ("summed magnitude of A0: %d\r\n",PSDmag1);  
             PSDmag2 = calcPSD(sampleddataemg2, 512);
             //pc.printf ("summed magnitude of A1: %d\r\n",PSDmag2);  
             PSDmag3 = calcPSD(sampleddataemg3, 512);
             //pc.printf ("summed magnitude of A2: %d\r\n",PSDmag3);  
             PSDmag4 = calcPSD(sampleddataemg4, 512);
             //pc.printf ("summed magnitude of A3: %d\r\n",PSDmag4);  
            fftflag = false; // this need to be false for continuous operation, now it is a one-shot kill
        }
    }
}


int main()
{
    ADCTimer.attach(&sampling, 0.1/1024);
    pc.baud(19200);
    while(1) {
    }




}
