
// This file contains an implementation of complex mathmatics
// i.e. definition of a complex unit and basic operationds such as magnitude, phase, addition and multiplication

#pragma once
#ifndef _COMPLEX_MATH_H
#define _COMPLEX_MATH_H

#include "LookupTables.h"
#include <math.h> // only for sqrt, not for cos sin

struct complex_num{
	float imaginary;
	float real;
};

// Complex adition and multiplication
complex_num complex_add(complex_num A, complex_num B);
complex_num complex_multiply(complex_num A, complex_num B);

// Retrieve the phase and magnitude of a complex number (polar form)
float complex_phase(complex_num A);
float complex_magnitude(complex_num A);

// Transform polar form to a complex number (phase in radians)
complex_num complex_transform(float phase, float magnitude);

// Complex conjugate
complex_num complex_conjugate(complex_num A);

#endif
