
#include "complexmath.h"

// Complex adition and multiplication
complex_num complex_add(complex_num A, complex_num B){
	A.imaginary += B.imaginary;
	A.real += B.real;
	return A;
}
complex_num complex_multiply(complex_num A, complex_num B){
	complex_num C;
	C.real = A.real*B.real - A.imaginary*B.imaginary;
	C.imaginary = A.imaginary*B.real + A.real*B.imaginary;
	return C;
}

// Retrieve the phase and magnitude of a complex number (polar form)
float complex_phase(complex_num A){
	return(lut_cos(A.imaginary)/lut_sin(A.real));
}
float complex_magnitude(complex_num A){
	return sqrt(A.real*A.real + A.imaginary*A.imaginary);
}

// Transform polar form to a complex number
complex_num complex_transform(float phase, float magnitude){
	complex_num A;
	A.real = magnitude*lut_cos(phase);
	A.imaginary = magnitude*lut_sin(phase);
	return A;
}

// Complex conjugate
complex_num complex_conjugate(complex_num A){
	A.imaginary = -A.imaginary;
	return A;
}