
// This file first preprocesses a 1024 long data array by:
// - Calculating and substracting the mean
// - Applying a hanning window
// - Re-indexing the array
// It then applies a radix-2 Cooley Tukey FFT to create a DFT of the original signal

#pragma once
#ifndef _DFT_H_
#define _DFT_H_

#include <string.h> // Only for memcpy
#include "LookupTables.h"
#include "complexmath.h"

// Preprocesses the data array and performs a dft on it, ARRAY MUST BE 1024 LONG
void performFFT(float* datam, int datalength);

// Performs a radix-2 cooley tukey FFT on the data array
void cooleyTukeyRadix2(float* data, int datalength);

// Calculates and subtracts the signal mean
void subMean(float* data, int datalength);

// Reindexes the array in preperation of the FFT
void reindexData(float* data, int datalength);

// Removes the DC component and null everything above the nyquist frequency
void afterProcessing(float* data, int datalength);

// Filter a frequency and its multiples
void filterfreq(int frequency, float* data, int datalength);

// Calculate total magnitude, frequency magnitude component integrating module (FMCIM)
int calcPSD(float* data, int datalength);

#endif