#include "mbed.h"
#include "FFT.h"
#include "LookupTables.h"
#include "complexmath.h"
#include <math.h>

//TODO right values for  the LUT equalizer 

//TODO Build all functions in FFT.cpp

//TODO fix main for a test wave and communication to serial

Serial pc(USBTX, USBRX);
float sampleDataIn[512];
float sampleDataOut[512];
complex_num freqValues[512];
complex_num reordereddata[512];
int datalength = 512;//uitrekenen?

int main()
{
    pc.baud(115200);
    pc.printf ("building input:[");
    for (int i=0; i<511; i++){
        if (i%128<64){
            sampleDataIn[i]=1000;
            pc.printf ("%f,\t",sampleDataIn[i]);
            }
        else{
            sampleDataIn[i]=0;
            pc.printf ("%f,\t",sampleDataIn[i]);
            }
        }
    sampleDataIn[511]=0;
    pc.printf("%f]\r\n",sampleDataIn[511]);
    //dont performEqualizer(&sampleDataIn, &sampleDataOut, &freqValues, datalength); but seperate functions for testing purposes
    // - Calculating and substracting the mean  -
    subMean(sampleDataIn, datalength);
    pc.printf ("zero meaned:[");
    for (int i=0; i<511; i++){
        pc.printf ("%f,\t",sampleDataIn[i]);
        }
    pc.printf("%f]\r\n",sampleDataIn[511]);
    // - Applying a hanning window - N multiplications
    applyHanningTable(sampleDataIn, datalength);
    pc.printf ("hanned:[");
    for (int i=0; i<511; i++){
        pc.printf ("%f,\t",sampleDataIn[i]);
        }
    pc.printf("%f]\r\n",sampleDataIn[511]);
    // It then applies a radix-2 Cooley Tukey FFT to create a fourier transform
    reverseCooleyTukeyRadix2(sampleDataIn, freqValues, datalength);

    for (int i = 0; i < datalength; i++){
        reordereddata[reversebit_lut_i[i]].real = freqValues[i].real;
        reordereddata[reversebit_lut_i[i]].imaginary = freqValues[i].imaginary;
    }
    pc.printf ("real part of freqValues:[");
    for (int i=0; i<511; i++){
        pc.printf ("%f,\t",reordereddata[i].real);
        }
    pc.printf("%f]\r\n",reordereddata[511].real);
    pc.printf ("imaginary part of freqValues:[");
    for (int i=0; i<511; i++){
        pc.printf ("%f,\t",reordereddata[i].imaginary);
        }
    pc.printf("%f]\r\n",reordereddata[511].imaginary);
    // It gets equalized
    //equalizer(complex_num* freqdata);
    // back to time domain
    cooleyTukeyBack(sampleDataOut, freqValues, datalength);
    pc.printf ("Equalized data :[");
    for (int i=0; i<511; i++) {
        pc.printf ("%f,\t",sampleDataOut[i]);
        }
    pc.printf("%f]\r\n",sampleDataOut[511]);
    while(1) {
    }




}